#ifndef WOUNDDETECTION_HPP
#define WOUNDDETECTION_HPP

#include <opencv2/core/core.hpp>
#include "utilsConcepts.hpp" //ColorSpace, PatchType

extern 
cv::Mat
computeWoundMask(const cv::Mat &img, 
		 const cv::Mat &markerMask,
		 const std::vector<std::vector<cv::Point> > &inputSkinPts,
		 const std::vector<std::vector<cv::Point> > &inputWoundPts,
		 const std::string &modelFilename1, const std::string &normalizeFilename1,
		 const std::string &modelFilename2, const std::string &normalizeFilename2,
		 const std::string &modelFilename3, const std::string &normalizeFilename3,
		 int smallSize,
		 int nbClasses,
		 ColorSpace cs,
		 int patchSize,
		 PatchType patchType, 
		 bool useL, 
		 bool saveInColors,
		 const std::string &minMaxDistFilename1, 
		 const std::string &minMaxDistFilename2, 
		 const std::string &minMaxDistFilename3);

#ifdef SAVE_SEG
extern cv::Mat
makeImageWithBorderAndPts(const cv::Mat &img, 
			  const cv::Mat &woundMask, 
			  const std::vector< std::vector<cv::Point> > &skinPts,
			  const std::vector< std::vector<cv::Point> > &woundPts);

#endif

#endif /* ! WOUNDDETECTION_HPP */
