#ifndef UTILS_SEG_HPP
#define UTILS_SEG_HPP


#include <ise/iseColorimetricMomentsComputer.hpp>
#include <ise/iseStat.hpp>



#define REJECT_SATURATED_PIXELS 0


/*
 transform a BGR 8 or 16bit 3channel image in a RGBA 16 bit 4channel images

 */
static
void
BGR2girlToolsImage(const cv::Mat &in, cv::Mat &out)
{
  assert(in.channels() == 3);

  //For cv::mixChannels: all matrices must have the same size and same depth,
  //  and all matrices must have been allocated.

  out = cv::Mat(in.rows, in.cols,  CV_MAKETYPE(in.depth(), 4));
  
  //bgr[0]->rgba[2] ; bgr[1]->rgba[1] ; bgr[2]->rgba[0] ; 
  //special case : -3,3 : to fill output channel rgba[3] to zero
  int from_to[] = {0,2, 1,1, 2,0, -3,3};
  cv::mixChannels(&in, 1, &out, 1, from_to, 4);
  
  if (out.depth() != cv::DataDepth<girl::tools::Image::type>::value) {
    cv::Mat out16(in.rows, in.cols,  CV_MAKETYPE(cv::DataDepth<girl::tools::Image::type>::value, 4));
    out.convertTo(out16, out16.type());
    out = out16;
  }

}


static
void
BGR2girlToolsImage(const cv::Mat &img, girl::tools::Image &gt)
{
  cv::Mat img2;
  BGR2girlToolsImage(img, img2);
  gt = girl::tools::Image(img2); //can not be const  //TODO:OPTIM: there is a useless convert !!!???
}


namespace {

class NonStaruratedColorimetricMomentsComputer : public girl::toger::pointIterator
  {
  public:
  
    explicit NonStaruratedColorimetricMomentsComputer(const girl::tools::Image &img)
      : m_img(img),
	m_m2(0.0, 0.0, 0.0),
	m_m1(0.0, 0.0, 0.0),
	m_m0(0.0)
    {
    }

    void clear()
    {
      m_m2 = girl::tools::Flt3(0.0, 0.0, 0.0);
      m_m1 = girl::tools::Flt3(0.0, 0.0, 0.0);
      m_m0 = 0.0;
    }

    void processPoint(const girl::point &pt)
    {
      const girl::tools::Pixel p = m_img.getPixel(pt.x(), pt.y());

      static const unsigned char delta = 3;
      const unsigned char uTh = 255-delta;
      const unsigned char lTh = 0+delta;

      const int x = p[0];
      const int y = p[1];
      const int z = p[2];

      if ((x >= lTh) && (x <= uTh) && (y >= lTh) && (y <= uTh) && (z >= lTh) && (z <= uTh)) {
	//not a saturated pixel

	m_m0 += 1;

	const girl::tools::Flt3 c(static_cast<girl::tools::Flt>(x), static_cast<girl::tools::Flt>(y), static_cast<girl::tools::Flt>(z));
	const girl::tools::Flt3 cs(static_cast<girl::tools::Flt>(x*x), static_cast<girl::tools::Flt>(y*y), static_cast<girl::tools::Flt>(z*z));
	m_m1 += c;
	m_m2 += cs;
      }

    }

  private:

    NonStaruratedColorimetricMomentsComputer(const NonStaruratedColorimetricMomentsComputer&);

    NonStaruratedColorimetricMomentsComputer &operator=(const NonStaruratedColorimetricMomentsComputer&);

  public:
    const girl::tools::Image &m_img;
    girl::tools::Flt3 m_m2;
    girl::tools::Flt3 m_m1;
    girl::tools::Flt m_m0;
  };

} //end anonymous namespace


static const cv::Vec3b skinColor(255, 170, 170); //BGR
static const cv::Vec3b woundColor(165, 125, 229); //BGR


#endif /* ! UTILS_SEG_HPP */

