#include <iostream>

#include "pointsUtils.hpp"


#include <cstdio>
#include <cstdlib>
             
#define CHECK(condition) \
  ((condition)?((void)(0)):((void)(fprintf(stderr, "%s:%d Assertion \'%s\' failed.\n",  __FILE__, __LINE__, # condition), \
      (void)(abort()) ))) 

cv::Mat
makeMask(int width, int height)
{
  cv::Mat mask = cv::Mat::zeros(width, height, CV_8UC1);
  const int thirdW = width /3;
  const int thirdH = height / 3;
  const int x0 = thirdW;
  const int x1 = std::min(x0+thirdW, width);
  const int y0 = thirdH;
  const int y1 = std::min(y0+thirdH, height);
  for (int i=y0; i<y1; ++i) {
    unsigned char *m = mask.ptr<unsigned char>(i);
    for (int j=x0; j<x1; ++j) {
      m[j] = 255;
    }
  }
  return mask;
}




int
main()
{
  int WIDTH = 300;
  int HEIGHT = 300;
  
  cv::Mat mask = makeMask(WIDTH, HEIGHT);

  {
    //test : 1 seul vecteur de 4 pts, 2 pts dans mask,
    //donc output = 1 seul vecteur de 2 pts
    
    cv::Point pt1(10, 10);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt1);
    v1.push_back(pt2);
    v1.push_back(pt3);
    v1.push_back(pt4);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    CHECK(v1.size() == 4);
    CHECK(vv.size() == 1);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 2);
    CHECK(vv2[0].size() == 1);
    CHECK((vv2[0])[0] == pt1);
    CHECK(vv2[1].size() == 1);
    CHECK((vv2[1])[0] == pt4);
  }

  {
    //test : 1 seul vecteur de 4 pts, 2 pts dans mask,
    //donc output = 2 seul vecteur de 2 pts
    
    cv::Point pt1(10, 10);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt2);
    v1.push_back(pt1);
    v1.push_back(pt3);
    v1.push_back(pt4);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    CHECK(v1.size() == 4);
    CHECK(vv.size() == 1);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 2);
    CHECK(vv2[0].size() == 1);
    CHECK((vv2[0])[0] == pt1);
    CHECK(vv2[1].size() == 1);
    CHECK((vv2[1])[0] == pt4);
  }

  {
    //test : 1 seul vecteur de 4 pts, 2 pts dans mask,
    //donc output = 1 seul vecteur de 2 pts
    
    cv::Point pt1(10, 10);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt2);
    v1.push_back(pt1);
    v1.push_back(pt4);
    v1.push_back(pt3);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    CHECK(v1.size() == 4);
    CHECK(vv.size() == 1);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 1);
    CHECK(vv2[0].size() == 2);
    CHECK((vv2[0])[0] == pt1);
    CHECK((vv2[0])[1] == pt4);
  }

  {
    //test : 4 vecteurs (1pt chacun) 2 pts dans mask
    //donc output = 2 vecteurs de 1 pts
    
    cv::Point pt1(10, 10);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt1);
    std::vector<cv::Point> v2;
    v2.push_back(pt2);
    std::vector<cv::Point> v3;
    v3.push_back(pt3);
    std::vector<cv::Point> v4;
    v4.push_back(pt4);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    vv.push_back(v2);
    vv.push_back(v3);
    vv.push_back(v4);
    CHECK(v1.size() == 1);
    CHECK(v4.size() == 1);
    CHECK(vv.size() == 4);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 2);
    CHECK(vv2[0].size() == 1);
    CHECK(vv2[1].size() == 1);
    CHECK((vv2[0])[0] == pt1);
    CHECK((vv2[1])[0] == pt4);
  }

  {
    //test : 4 vecteurs (1pt chacun) 2 pts dans mask
    //donc output = 2 vecteurs de 1 pts
    
    cv::Point pt1(10, 10);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt2);
    std::vector<cv::Point> v2;
    v2.push_back(pt1);
    std::vector<cv::Point> v3;
    v3.push_back(pt4);
    std::vector<cv::Point> v4;
    v4.push_back(pt3);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    vv.push_back(v2);
    vv.push_back(v3);
    vv.push_back(v4);
    CHECK(v1.size() == 1);
    CHECK(v4.size() == 1);
    CHECK(vv.size() == 4);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 2);
    CHECK(vv2[0].size() == 1);
    CHECK(vv2[1].size() == 1);
    CHECK((vv2[0])[0] == pt1);
    CHECK((vv2[1])[0] == pt4);
  }

  {
    //test : 4 vecteurs (1pt chacun) 2 pts dans mask
    //donc output = 2 vecteurs de 1 pts
    
    cv::Point pt1(10, 10);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt1);
    std::vector<cv::Point> v2;
    v2.push_back(pt2);
    std::vector<cv::Point> v3;
    v3.push_back(pt4);
    std::vector<cv::Point> v4;
    v4.push_back(pt3);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    vv.push_back(v2);
    vv.push_back(v3);
    vv.push_back(v4);
    CHECK(v1.size() == 1);
    CHECK(v4.size() == 1);
    CHECK(vv.size() == 4);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 2);
    CHECK(vv2[0].size() == 1);
    CHECK(vv2[1].size() == 1);
    CHECK((vv2[0])[0] == pt1);
    CHECK((vv2[1])[0] == pt4);
  }

  {
    //test : 4 vecteurs (1pt chacun) 2 pts dans mask
    //donc output = 2 vecteurs de 1 pts
    
    cv::Point pt1(10, 10);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt2);
    std::vector<cv::Point> v2;
    v2.push_back(pt1);
    std::vector<cv::Point> v3;
    v3.push_back(pt3);
    std::vector<cv::Point> v4;
    v4.push_back(pt4);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    vv.push_back(v2);
    vv.push_back(v3);
    vv.push_back(v4);
    CHECK(v1.size() == 1);
    CHECK(v4.size() == 1);
    CHECK(vv.size() == 4);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 2);
    CHECK(vv2[0].size() == 1);
    CHECK(vv2[1].size() == 1);
    CHECK((vv2[0])[0] == pt1);
    CHECK((vv2[1])[0] == pt4);
  }

  {
    //test : 3 vecteurs (1pt, 2pts, 1pts), 2 pts dans mask
    //donc output = 2 vecteurs de 1 pts
    
    cv::Point pt1(10, 10);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt1);
    std::vector<cv::Point> v2;
    v2.push_back(pt2);
    v2.push_back(pt3);
    std::vector<cv::Point> v3;
    v3.push_back(pt4);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    vv.push_back(v2);
    vv.push_back(v3);
    CHECK(v1.size() == 1);
    CHECK(v2.size() == 2);
    CHECK(v3.size() == 1);
    CHECK(vv.size() == 3);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 2);
    CHECK(vv2[0].size() == 1);
    CHECK(vv2[1].size() == 1);
    CHECK((vv2[0])[0] == pt1);
    CHECK((vv2[1])[0] == pt4);
  }

  {
    //test : 3 vecteurs (2pt, 1pts, 1pts), 2 pts dans mask
    //donc output = 2 vecteurs de 1 pts
    
    cv::Point pt1(10, 10);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt1);
    v1.push_back(pt2);
    std::vector<cv::Point> v2;
    v2.push_back(pt3);
    std::vector<cv::Point> v3;
    v3.push_back(pt4);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    vv.push_back(v2);
    vv.push_back(v3);
    CHECK(v1.size() == 2);
    CHECK(v2.size() == 1);
    CHECK(v3.size() == 1);
    CHECK(vv.size() == 3);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 2);
    CHECK(vv2[0].size() == 1);
    CHECK(vv2[1].size() == 1);
    CHECK((vv2[0])[0] == pt1);
    CHECK((vv2[1])[0] == pt4);
  }

  {
    //test : 3 vecteurs (1pt, 1pts, 2pts), 2 pts dans mask
    //donc output = 2 vecteurs de 1 pts
    
    cv::Point pt1(10, 10);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt1);
    std::vector<cv::Point> v2;
    v2.push_back(pt2);
    std::vector<cv::Point> v3;
    v3.push_back(pt3);
    v3.push_back(pt4);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    vv.push_back(v2);
    vv.push_back(v3);
    CHECK(v1.size() == 1);
    CHECK(v2.size() == 1);
    CHECK(v3.size() == 2);
    CHECK(vv.size() == 3);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 2);
    CHECK(vv2[0].size() == 1);
    CHECK(vv2[1].size() == 1);
    CHECK((vv2[0])[0] == pt1);
    CHECK((vv2[1])[0] == pt4);
  }


  {
    //test : 4 vecteurs (1pt chacun) 4 pts dans mask
    //donc output = 0 vecteurs
    
    cv::Point pt1(155, 155);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(167, 162);
    std::vector<cv::Point> v1;
    v1.push_back(pt2);
    std::vector<cv::Point> v2;
    v2.push_back(pt1);
    std::vector<cv::Point> v3;
    v3.push_back(pt3);
    std::vector<cv::Point> v4;
    v4.push_back(pt4);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    vv.push_back(v2);
    vv.push_back(v3);
    vv.push_back(v4);
    CHECK(v1.size() == 1);
    CHECK(v4.size() == 1);
    CHECK(vv.size() == 4);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 0);
  }

  {
    //test : 4 vecteurs (1pt chacun) 0 pts dans mask
    //donc output = 4 vecteurs
    
    cv::Point pt1(250, 250);
    cv::Point pt2(255, 255);
    cv::Point pt3(60, 60);
    cv::Point pt4(67, 62);
    std::vector<cv::Point> v1;
    v1.push_back(pt2);
    std::vector<cv::Point> v2;
    v2.push_back(pt1);
    std::vector<cv::Point> v3;
    v3.push_back(pt3);
    std::vector<cv::Point> v4;
    v4.push_back(pt4);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    vv.push_back(v2);
    vv.push_back(v3);
    vv.push_back(v4);
    CHECK(v1.size() == 1);
    CHECK(v4.size() == 1);
    CHECK(vv.size() == 4);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 4);
  }


  {
    //test : 4 vecteurs (1pt chacun) 3 pts dans mask
    //donc output = 2 vecteurs de 1 pts
    
    cv::Point pt1(162, 162);
    cv::Point pt2(150, 150);
    cv::Point pt3(160, 160);
    cv::Point pt4(250, 250);
    std::vector<cv::Point> v1;
    v1.push_back(pt1);
    std::vector<cv::Point> v2;
    v2.push_back(pt2);
    std::vector<cv::Point> v3;
    v3.push_back(pt3);
    std::vector<cv::Point> v4;
    v4.push_back(pt4);
    std::vector< std::vector<cv::Point> > vv;
    vv.push_back(v1);
    vv.push_back(v2);
    vv.push_back(v3);
    vv.push_back(v4);
    CHECK(v1.size() == 1);
    CHECK(v4.size() == 1);
    CHECK(vv.size() == 4);
    
    std::vector< std::vector<cv::Point> > vv2 = keepOnlyOutsideMask(vv, mask);
    CHECK(vv2.size() == 1);
    CHECK(vv2[0].size() == 1);
    CHECK((vv2[0])[0] == pt4);
  }


  std::cout<<"all tests passed.\n";
  return 0;
}
