#ifdef SAVE_PROBA

static
void
drawPts(cv::Mat &img,
	const std::vector<cv::Point> &pts,
	const cv::Scalar &color = cv::Scalar(0, 255, 0))
{
  assert(img.type() == CV_8UC3);
  
  const int radius = 3;

  const size_t numPts = pts.size();
  for (size_t i=0; i<numPts; ++i) {
    cv::circle(img, pts[i], radius, color);
  }
}

static
void
drawPts(cv::Mat &img,
	const std::vector< std::vector<cv::Point> > &ptsV,
	const cv::Scalar &color = cv::Scalar(0, 255, 0))
{
  const size_t numV = ptsV.size();
  for (size_t i=0; i<numV; ++i) {
    drawPts(img, ptsV[i], color);
  }
}

#endif //SAVE_PROBA


