#ifndef LAB_HPP
#define LAB_HPP

#include <cstddef> //size_t

static
inline
unsigned char
CLAMP_TO_UCHAR(int a)
{
  return (a<0?0:(a>255?255:a));
}
static
inline
unsigned char
CLAMP_TO_UCHAR(float a)
{
  return CLAMP_TO_UCHAR(static_cast<int>(a+0.5f));
  //B: no need to do a FLOAT_TO_INT !
}


extern void RGBgammaCorrected_to_linear(unsigned char R, unsigned char G, unsigned char B, float &Rf, float &Gf, float &Bf);
extern void RGBgammaCorrected_to_linear_fastP(unsigned char R, unsigned char G, unsigned char B, float &Rf, float &Gf, float &Bf);
extern void RGBgammaCorrected_to_linear(float R, float G, float B, float &Rf, float &Gf, float &Bf);

extern void RGBlinear_to_gammaCorrected(float Rf, float Gf, float Bf, unsigned char &R, unsigned char &G, unsigned char &B);
extern void RGBlinear_to_gammaCorrected_fastP(float Rf, float Gf, float Bf, unsigned char &R, unsigned char &G, unsigned char &B);



//convert from RGB to Lab illuminant D65
extern void convertRGBtoLabD65(const unsigned char rgb[][3], float lab[][3], size_t size);
extern void convertRGBtoLabD65(const float rgb[][3], float lab[][3], size_t size);

extern void RGB_to_XYZ(unsigned char R, unsigned char G, unsigned char B, float &x, float &y, float &z);
extern void RGB_to_XYZ(float R, float G, float B, float &x, float &y, float &z);

//convert RGB to Lab illuminant D65
extern void RGB_to_LAB(unsigned char R, unsigned char G, unsigned char B, float &L, float &a, float &b);
extern void RGB_to_LAB(float R, float G, float B, float &L, float &a, float &b);

extern void RGB_to_L(unsigned char R, unsigned char G, unsigned char B, float &L);

//convert from Lab illuminant D65 to RGB
extern void convertLabD65toRGB(const float lab[][3], unsigned char rgb[][3], size_t size);

//convert from Lab illuminant D65 to RGB
extern void LAB_to_RGB(float L, float a, float b,
		       unsigned char &R, unsigned char &G, unsigned char &B);

//convert from Lab illuminant D50 to Lab illuminant D65
extern void convertLabD50toLabD65(const float labD50[][3], float labD65[][3], size_t size);





//convert RGB to Luv illuminant D65
extern void RGB_to_LUV(unsigned char R, unsigned char G, unsigned char B, float &L, float &a, float &b);
extern void RGB_to_LUV(float R, float G, float B, float &L, float &a, float &b);


#endif /* ! LAB_HPP */
