#include "hsv.hpp"

#include <iostream>

/* Additional function to sort r, g, b values.
 * Return a char characterizing the order of r, g, b values :
 *  0=rgb, 1=gbr, 2=grb, 3=rbg, 4=bgr, 5=brg
 * Gives the maximum and minimum values in maxrgb and minrgb parameters
 */
template <typename T>
char 
sortRGB(T R, T G, T B, T *minrgb, T *maxrgb)
{
  static char order;

  if (G > B)
    {
      if (R > G)
	{
	  *maxrgb = R;
	  *minrgb = B;
	  order = 0;
	}
      else 
	{
	  if (B > R)
	    {
	      *maxrgb = G;
	      *minrgb = R;
	      order = 1;
	    }
	  else
	    {
	      *maxrgb = G;
	      *minrgb = B;
	      order = 2;
	    }
	}
    }
  else 
    {
      if (R > B)
	{
	  *maxrgb = R;
	  *minrgb = G;
	  order = 3;
	}
      else
	{
	  if (G > R)
	    {
	      *maxrgb = B;
	      *minrgb = R;
	      order = 4;
	    }
	  else
	    {
	      *maxrgb = B;
	      *minrgb = G;
	      order = 5;
	    }
	}
    }

  return order;
}

static
float
computeH(unsigned char r, unsigned char g, unsigned char b, 
	 char order)
{
  float floatH;
    
  switch(order) { //0=rgb, 1=gbr, 2=grb, 3=rbg, 4=bgr, 5=brg
  case 0 : 
    floatH = 1.0f - static_cast<float>(r - g) / static_cast<float>(r - b);
    break;
  case 1 :
    floatH = 3.0f - static_cast<float>(g - b) / static_cast<float>(g - r);
    break;
  case 2 :
    floatH = 1.0f + static_cast<float>(g - r) / static_cast<float>(g - b);
    break;
  case 3 :
    floatH = 5.0f + static_cast<float>(r - b) / static_cast<float>(r - g);
    break;
  case 4 :
    floatH = 3.0f + static_cast<float>(b - g) / static_cast<float>(b - r);
    break;
  case 5 :
    floatH = 5.0f - static_cast<float>(b - r) / static_cast<float>(b - g);
    break;
  default :
    std::cerr<<"Error:  Internal error in RGB to H transformation\n";
    floatH = 0.0f;
  }
  
  return floatH / 6.f * 359.f;
}

void
RGB_to_HSV(unsigned char r, unsigned char g, unsigned char b, float &h, float &s, float &v)
{
  h = 0;
  s = 0;

  int min, max;
  const char order = sortRGB<int>(r, g, b, &min, &max);

  v = max;

  if (max != min) {

    h = computeH(r, g, b, order);

    s = (max - min)  / (float)max * 255.f; //B: float ???

  }

}
