
//@param[in, out] imgProba
static
void
correctBoundsImageProba(cv::Mat &imgProba)
{
  assert(imgProba.type() == CV_32FC1);

  int rows = imgProba.rows;
  int cols = imgProba.cols;
  if (imgProba.isContinuous()) {
    cols *= rows;
    rows = 1;
  }

  for (int i=0; i<rows; ++i) {
    float *pf = imgProba.ptr<float>(i);
    for (int j=0; j<cols; ++j) {
      const float f = *pf;
      if (f < 0.f)
	*pf = 0.f;
      else if (f > 1.f)
	*pf = 1.f;
      ++pf;
    }
  }
}


static
void
makeWoundImage(const cv::Mat &imgBin, bool saveInColors, cv::Mat &outputImg)
{
  assert(imgBin.type() == CV_8UC1);

  outputImg.create(imgBin.rows, imgBin.cols, CV_8UC3);
  
  if (! saveInColors) {
    outputImg = imgBin;
  }
  else {
    //get a 3-channel image
    const unsigned char *s = imgBin.ptr<unsigned char>(0);
    cv::Vec3b *d = outputImg.ptr<cv::Vec3b>(0);
    assert(imgBin.isContinuous());
    assert(outputImg.isContinuous());
    const unsigned int wh = imgBin.rows*imgBin.cols;
    const unsigned char skinVal = 255;
    for (unsigned int j=0; j<wh; ++j) {
      if (*s == skinVal)
        *d = skinColor;
      else
        *d = woundColor;

      ++d;
      ++s;
    }
  }  

}


static
cv::Mat 
detectWoundMask(const std::string &modelFilename1,
		const std::string &modelFilename2,
		const std::string &modelFilename3,
		const cv::Mat &inputImage,
		const cv::Mat &markerMask,
		const std::vector<std::vector<cv::Point> > &inputSkinPts,
		const std::vector<std::vector<cv::Point> > &inputWoundPts,
		ColorSpace cs,
		int patchSize, PatchType patchType,
		int smallSize,
		int nbClasses,
		bool useL, 
		bool saveInColors,
		const Normalizer &n1, const Normalizer &n2, const Normalizer &n3,
		const MinMaxP &m1, const MinMaxP &m2, const MinMaxP &m3)
{

  cv::Mat markerMask1 = markerMask.clone();
   
 {
    const int d = SIZE_DILATE_MARKER_INIT;
    cv::Mat elt = cv::Mat::ones(d, d, CV_8U);
    cv::dilate(markerMask1, markerMask1, elt);
  }

  const bool useClassifier3 = (! modelFilename3.empty());
  
#if CV_MAJOR_VERSION*100+CV_MINOR_VERSION*10+CV_SUBMINOR_VERSION < 300
  CvSVM clas1;
  clas1.load(modelFilename1.c_str());
  Classifier classifier1 = &clas1;

  CvSVM clas2;
  clas2.load(modelFilename2.c_str());
  Classifier classifier2 = &clas2;
  
  CvSVM clas3;
  if (useClassifier3)
    clas3.load(modelFilename3.c_str());
  Classifier classifier3 = &clas3;

#else
  Classifier classifier1 = cv::ml::StatModel::load<cv::ml::SVM>(modelFilename1.c_str());
  Classifier classifier2 = cv::ml::StatModel::load<cv::ml::SVM>(modelFilename2.c_str());
  Classifier classifier3;
  if (useClassifier3)
    classifier3 = cv::ml::StatModel::load<cv::ml::SVM>(modelFilename3.c_str());  
#endif

  
#ifdef TIMING
  tcl = ((double)cv::getTickCount() - tcl)/cv::getTickFrequency();
  std::cout<<"*** Time for classifier loading: "<<tcl<<"s"<<std::endl;
#endif
  
  const cv::Mat &img = inputImage;
  
  //Reduce size of img !!!
  int dstLargeSide = smallSize;
  int srcLargeSide = img.cols;
  int srcSmallSide = img.rows;
  if (img.rows > img.cols) {
    srcLargeSide = img.rows;
    srcSmallSide = img.cols;
  }
  int dstSmallSide = static_cast<int>(srcSmallSide*dstLargeSide/(float)srcLargeSide + 0.5);
  if (img.rows > img.cols)
    std::swap(dstLargeSide, dstSmallSide);

  cv::Mat imgSmall;
  cv::resize(img, imgSmall, cv::Size(dstLargeSide, dstSmallSide), 0.0, 0.0, cv::INTER_LINEAR); //NEAREST); //AREA);  

  cv::Mat markerMaskSmall;
  cv::resize(markerMask1, markerMaskSmall, cv::Size(dstLargeSide, dstSmallSide), 0.0, 0.0, cv::INTER_NEAREST);
  
#if 1
  std::vector< std::vector<cv::Point> > SkinPts = keepOnlyOutsideMask(linkPoints(inputSkinPts, img.cols, img.rows), markerMask1);
  std::vector< std::vector<cv::Point> > WoundPts = linkPoints(inputWoundPts, img.cols, img.rows);
#else
  std::vector< std::vector<cv::Point> > SkinPts = keepOnlyOutsideMask(inputSkinPts, markerMask1);
  std::vector< std::vector<cv::Point> > &WoundPts = inputWoundPts;
#endif //1

  std::vector<std::vector<cv::Point> > smallSkinPts;
  zoomPoints(SkinPts, img.cols, img.rows, imgSmall.cols, imgSmall.rows, smallSkinPts);
  std::vector<std::vector<cv::Point> > smallWoundPts;
  zoomPoints(WoundPts, img.cols, img.rows, imgSmall.cols, imgSmall.rows, smallWoundPts);

  cv::Mat imgLABSmall;
  convert<ConverterLAB>(imgSmall, imgLABSmall);

  increaseMaskWithNonWoundColors(imgLABSmall, markerMaskSmall);


  cv::Mat imgProbaSmall;

  computeImageProba(classifier1, classifier2, classifier3, 
		    imgSmall, markerMaskSmall, imgLABSmall, cs, patchSize, patchType, useL, 
		    n1, n2, n3,  
		    m1, m2, m3,
		    useClassifier3, imgProbaSmall);

  increaseMaskWithSkinLAB(imgLABSmall, markerMaskSmall, smallSkinPts); 


  cv::Mat imgProba;
  cv::resize(imgProbaSmall, imgProba, inputImage.size(), 0.0, 0.0, cv::INTER_CUBIC);
  
  correctBoundsImageProba(imgProba);
  
  cv::Mat imgLAB;
  cv::resize(imgLABSmall, imgLAB, inputImage.size(), 0.0, 0.0, cv::INTER_CUBIC);

  const int touchRadius = static_cast<int>(DEFAULT_TOUCH_RADIUS);
  std::vector< std::vector<cv::Point> > SkinPts2;
  std::vector< std::vector<cv::Point> > WoundPts2;
  expandPointsNotInMask(SkinPts, markerMask, touchRadius, SkinPts2);
  expandPointsNotInMask(WoundPts, markerMask, touchRadius, WoundPts2);

  removeCommonPoints(SkinPts, WoundPts); 

#ifdef SAVE_PROBA
  {
    const std::string filename = g_outputProbaFilename+std::string("Big.png");
    std::cerr<<"save proba file: "<<filename<<"\n";
    cv::Mat imgProbaIMG;
    makeBGRImageFromImageProba(imgProba, imgProba.rows, imgProba.cols, imgProbaIMG, false);
    drawPts(imgProbaIMG, WoundPts2, cv::Scalar(0, 0, 255));
    drawPts(imgProbaIMG, SkinPts2, cv::Scalar(0, 255));
    const bool writeOk = cv::imwrite(filename, imgProbaIMG);
    if (! writeOk) {
      std::cerr<<"Error: unable to write proba image file: "<<filename<<"\n";
      exit(EXIT_FAILURE);
    }
  }
#endif //SAVE_PROBA


  cv::Mat markerAll;
  cv::resize(markerMaskSmall, markerAll, inputImage.size(), 0.0, 0.0, cv::INTER_NEAREST); //try cv::INTER_LINEAR(faster) ??  

 //- dilate & vignette 
  cv::Mat markerMaskL = cv::Mat::zeros(img.rows, img.cols, CV_8UC1);
  modifyMaskAccordingToL(imgLAB, 85, markerMaskL);

#ifdef SAVE_PROBA
  {
    const std::string filename =  g_outputBurnedPixelFilename; 
    cv::Mat imgShow = inputImage.clone();
  
    for (int i=0; i < inputImage.rows; ++i) 
      {
	unsigned char *dP = markerMaskL.ptr<unsigned char>(i);
	cv::Vec3b *img = imgShow.ptr<cv::Vec3b>(i);
	for (int j=0; j<inputImage.cols; ++j) 
	  if (dP[j] == 255)
	    {
	      cv::Vec3b &pix = img[j];
	      pix[0] = pix[1] = 0;
	      pix[2] = 255;
	    }
      }
    
    const bool writeOk = cv::imwrite(filename, imgShow);
    if (! writeOk) 
      {
	std::cerr<<"Error: unable to write proba image file: "<<filename<<"\n";
	exit(EXIT_FAILURE);
      }
  }
#endif //SAVE_PROBA



  cv::Mat outImgC = cv::Mat::zeros(img.rows, img.cols, CV_8UC1);
  segmentation(inputImage, imgProba, outImgC, SkinPts2, WoundPts2, markerAll);  //result is in outImgC
  


#ifdef SAVE_PROBA
  {
    const std::string filename = g_outputCarteProbaFilename;
    cv::Mat imgProbaIMG;
    makeBGRImageFromImageProba(imgProba, imgProba.rows, imgProba.cols, imgProbaIMG, false);
    drawPts(imgProbaIMG, WoundPts2, cv::Scalar(0, 0, 255));
    drawPts(imgProbaIMG, SkinPts2, cv::Scalar(0, 255));
    const bool writeOk = cv::imwrite(filename, imgProbaIMG);
    if (! writeOk) {
      std::cerr<<"Error: unable to write proba image file: "<<filename<<"\n";
      exit(EXIT_FAILURE);
    }
  }
#endif //SAVE_PROBA


  cv::Mat outputImg;
  makeWoundImage(outImgC, saveInColors, outputImg);


  return outputImg;

}
