#ifndef DEFINEURGO_HPP
#define DEFINEURGO_HPP

#include "utilsConcepts.hpp" //PatchType


struct MinMaxP
{
  MinMaxP()
    : minP(0.0), maxP(-1.0)
  {}
  
  float minP;
  float maxP;
};


static const int DEFAULT_NBCLASSES = 15;
static const bool DEFAULT_USE_L = true;
static const bool DEFAULT_NORMALIZE = false; //false; ?? //normalization already done by OpenCV ???
static const int DEFAULT_PATCH_SIZE = 5;
static const PatchType DEFAULT_PATCH_TYPE = eMEAN_STDDEV; //eMean_STDDEV; //eLAB_VALUES; //{eMTS=0, eMEAN_VAR, eLAB_VALUES, eMEAN_STDDEV, eLAB_VALUES_UNSORTED, eMEAN}
static const ColorSpace DEFAULT_COLORSPACE = eLAB; //{eLAB=0, eHSV, eCMY, eHSL, eSMY, eRGB, eLUV, eXYZ}
static const bool DEFAULT_SAVE_IN_COLORS = false; //true;
static const int DEFAULT_SMALL_SIZE = 140; //180;
static const int DEFAULT_TOUCH_RADIUS = 5;

static const int DEFAULT_INSIDEWOUND__NBCLASSES = 15;
static const bool DEFAULT_INSIDEWOUND__USE_L = true; //true;
static const int DEFAULT_INSIDEWOUND__PATCH_SIZE = 5; //3;
static const PatchType DEFAULT_INSIDEWOUND__PATCH_TYPE = eMEAN_STDDEV; //eLA_SORTED; //eMEAN_STDDEV; //eLAB_VALUES;
static const ColorSpace DEFAULT_INSIDEWOUND__COLORSPACE = eLAB;




static const bool DEFAULT_INSIDEWOUND__NORMALIZE = false; //false; ?? //normalization already done by OpenCV ???

static const int DEFAULT_INSIDEWOUND__SMALL_SIZE = 180;

static const bool DEFAULT_DO_WHITEBALANCE = false; //true;

enum InsideWoundPercent {
  IW_PERCENT_FIBRINE=0,
  IW_PERCENT_BOURGEON,
  IW_PERCENT_NECROSE,
  IW_PERCENT_SIZE //should always be last
};


#ifdef SAVE_PROBA
//#include "drawSeg.hpp"
//#include <girlTools/girlToolsPainter.hpp>
//std::string g_outputCreatedRegionsFilename = "";
//std::string g_outputSkinRegionsFilename = "";
//std::string g_outputPotentialWoundRegionsFilename = "";
//std::string g_outputNecroseFilename = "";
//std::string g_outputPointsFilename = "";
// std::string g_outputCarteProbaFilename = "";
//std::string g_outputGrowMarkerFilename = "";
 // std::string g_outputInsideMaskFilename = "";
 // std::string g_outputKeptImageFilename = "";
 // std::string g_outputBurnedPixelFilename = "";
 // std::string g_outputSkinWoundMarkerFilename = "";
 // std::string g_outputOutsideMaskFilename = "";
 // std::string g_outputSkinWithProbaFilename ="";
 // std::string g_outputProbaFinalFilename ="";
 // std::string g_outputBeforeFilename ="";
 // std::string g_outputAfterFilename ="";
 // std::string g_outputProbaExtendConvexHull="";
#endif // SAVE_PROBA




// ALGO PARAM 


static const int SIZE_DILATE_MARKER_INIT = 50;


static const float skinMaskThresholdExtendL = 15.0f;
static const float skinMaskThresholdExtendA = 8.0f;
static const float skinMaskThresholdExtendB = 8.0f;

static const float skinThresholdExtendL = 15.0f;
static const float skinThresholdExtendA = 8.0f;
static const float skinThresholdExtendB = 8.0f;

static const int sizeRectSkinTouch = 5;

static const float thresholdWoundMergeFinal1 = 0.55;
static const float thresholdRatioAreaIncluded = 0.4;

const float thBurnedPixel= 80.0f;



#endif /* ! DEFINEURGO_HPP */
