#include <iostream>
#include <iomanip>
#include <sstream>
#include <fstream>
#include <vector>
#include <limits>

#include <unistd.h>
#include <cassert>
#include <getopt.h>

#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/ml/ml.hpp>

#include "marker.hpp"



//#define DEBUG_VISU 1
//#define SAVE_PROBA 1
//#define TIMING 1



static
void
usage(char* argv0)
{
  std::cerr<<"Usage: "<<argv0<<" inputImageFilename outputImageFilename"<<std::endl;
}



static
void
processArgs(int argc, char *argv[],
	    std::string &inputFilename,
	    std::string &outputFilename)
{
  if (argc != 3) {
    usage(argv[0]);
    exit(EXIT_FAILURE);
  }
  inputFilename = argv[1];
  outputFilename = argv[2];

  if (inputFilename.empty()) {
    std::cerr << "Error: unspecified input filename\n";
    usage(argv[0]);
    exit(EXIT_FAILURE);
  }
  if (outputFilename.empty()) {
    std::cerr << "Error: unspecified output filename\n";
    usage(argv[0]);
    exit(EXIT_FAILURE);
  }

}



int
main(int argc, char *argv[])
{
  srand(time(NULL));

  std::string inputFilename;
  std::string outputFilename;

  processArgs(argc, argv, 
	      inputFilename,
	      outputFilename);
  
  cv::Mat img = cv::imread(inputFilename);
  if (img.empty()) {
    std::cerr<<"Error: unable to load image file: "<<inputFilename<<"\n";
    exit(EXIT_FAILURE);
  }

  //detection of marker on non color-corrected image
  float pixelSize = 0;
  cv::Mat markerMask;
  cv::Vec3f blue, white;
  const bool markerDetectionOk = detectMarker(img, pixelSize, markerMask, blue, white);
  if (! markerDetectionOk) {
    std::cerr<<"Error: unable to detect marker on image "<<inputFilename<<"\n";
    exit(EXIT_FAILURE);
  }
  if (pixelSize <= std::numeric_limits<float>::epsilon() || pixelSize > (img.rows+img.cols)/2.f) {
    std::cerr<<"ERROR: invalid pixelSize="<<pixelSize<<"\n";
    exit(EXIT_FAILURE);
  }

  cv::Mat imgC = correctWhite(img, white);

  cv::imwrite(outputFilename, imgC);
  

  return 0;
}


