#include <iostream>
#include <iomanip>
#include <sstream>
#include <fstream>
#include <vector>
#include <limits>

#include <unistd.h>
#include <cassert>
#include <getopt.h>

#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/ml/ml.hpp>

#include "marker.hpp"



//#define DEBUG_VISU 1
//#define SAVE_PROBA 1
//#define TIMING 1



static
void
usage(char* argv0)
{
  std::cerr<<"Usage: "<<argv0<<" inputImageFilename"<<std::endl;
}



static
void
processArgs(int argc, char *argv[],
	    std::string &inputFilename)
{
  if (argc != 2) {
    usage(argv[0]);
    exit(EXIT_FAILURE);
  }
  inputFilename = argv[1];

  if (inputFilename.empty()) {
    std::cerr << "Error: unspecified input filename\n";
    usage(argv[0]);
    exit(EXIT_FAILURE);
  }


}



int
main(int argc, char *argv[])
{
  srand(time(NULL));

  std::string inputFilename;

  processArgs(argc, argv, 
	      inputFilename);
  
  cv::Mat img = cv::imread(inputFilename);
  if (img.empty()) {
    std::cerr<<"Error: unable to load image file: "<<inputFilename<<"\n";
    exit(EXIT_FAILURE);
  }

  std::vector<cv::Point> blueContour, whiteContour;
  const bool markerDetectionOk = findMarkerContours(img, blueContour, whiteContour);
  
  if (! markerDetectionOk) {
    std::cerr<<"Error: unable to detect marker on image "<<inputFilename<<"\n";
    exit(EXIT_FAILURE);
  }

  float meanBlue[3];
  float stdDevBlue;
  float meanWhite[3];
  float stdDevWhite;
  
  computeMarkerColorStats(img, blueContour, whiteContour,
			  meanBlue, stdDevBlue, meanWhite, stdDevWhite);

  std::cerr<<"blue: ("<<meanBlue[0]<<", "<<meanBlue[1]<<", "<<meanBlue[2]<<") stdDev="<<stdDevBlue<<"\n";
  std::cerr<<"white: ("<<meanWhite[0]<<", "<<meanWhite[1]<<", "<<meanWhite[2]<<") stdDev="<<stdDevWhite<<"\n";
  

  return 0;
}


