/*
  This program takes an unique image where the toger is drawn.
  It extracts the wound and save the corresponding mask.

  Warning: it extracts ONLY ONE region !

  CODE DUPLICATION with computeInsideWoundMask.cpp
*/

#include <limits>

#include <girl/girlToger.hpp>

#include <girl/euclideanPathSet.hpp>
#include <girlTools/girlToolsPainter.hpp>
#include <girlTools/girlToolsRegionInfos.hpp>

#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>

#include <iostream>

#include "defineUrgoEye.hpp"


//static int DBG = 0;

static
bool
isGreen(const cv::Vec3b &p)
{
  //36,233,22 //58,216,41 //33,237,16 //65,215,45 //158,236,134
  
  //return (p[0]>40 && p[0] < 70 && p[1] > 80 && p[2] > 50 && p[2] < 60);
  //return ((int)(p[0]) < 46 && (int)(p[1]) > 208 && (int)(p[2]) < 66);
  return ((int)(p[0]) < 138 && (int)(p[1]) > 200 && (int)(p[2]) < 162);
}

/*
static
bool
isViolet(const cv::Vec3b &p)
{
  return ((int)(p[0]) == 255 && (int)(p[1]) == 0 && (int)(p[2]) == 255);
}
*/
  
class Splitter : public girl::toger::sameRegion
{
  const cv::Mat &m_imgP;

public:
  explicit Splitter(const cv::Mat &imgP)
    : m_imgP(imgP)
  {
    assert(m_imgP.type() == CV_8UC3);
  }

  virtual bool same(const girl::point &p, girl::direction dir)
  {
    girl::point p2 = p;
    p2.move(dir);

    const cv::Vec3b pix1 = m_imgP.at<cv::Vec3b>(p.y(), p.x());
    const cv::Vec3b pix2 = m_imgP.at<cv::Vec3b>(p2.y(), p2.x());

    const bool b1 = isGreen(pix1);
    const bool b2 = isGreen(pix2);

    return b1 == b2;
  }
		
};

class PointIterator : public girl::tools::BoundaryPointIterator
{
  int m_width, m_height;
  size_t m_onBorder;

public:

  PointIterator(int w, int h)
    : m_width(w), m_height(h), m_onBorder(0)
  {}
  
  void processPoint(const girl::point &p)
  {
    //if (p.x() == -1 || p.y() == -1 || p.x() == m_width-1 || p.y() == m_height-1)
    if (p.x() <= 1 || p.y() <= 1 || p.x() >= m_width-3 || p.y() >= m_height-3)
    
      ++m_onBorder;
  }

  size_t nbPtsOnBorder() const
  {
    return m_onBorder;
  }
  
};

size_t
nbPtsOnBorder(const girl::toger &tog, const girl::region r)
{
  PointIterator pi(tog.width(), tog.height());
  tog.iterateOnFaceBoundary(r, pi);
  const size_t nb = pi.nbPtsOnBorder();
  
  return nb;
}

girl::region
findWoundRegion(const girl::toger &tog, const girl::regionDeque createdRegions)
{
  //return biggest region not on the border (with area superior to MIN_AREA)
  // or if all regions touch the border : region with the smallest nb of points on border

  const size_t MIN_AREA = 18;
  
  girl::region rr = 0;
  size_t rrArea = 0;
  size_t rrNbPts = std::numeric_limits<size_t>::max();
  for (girl::regionDeque::const_iterator it = createdRegions.begin();
       it != createdRegions.end();
       ++it) {

    const girl::region r = *it;
    const size_t nb = nbPtsOnBorder(tog, r);

    //std::cerr<<"region "<<r<<" nbPtsOnBorder="<<nb<<"\n";
    
    if (nb == 0) {
      const size_t area = girl::tools::computeArea(tog, r);
      if (area > MIN_AREA) {
	//std::cerr<<"region "<<r<<" not on border & of area="<<area<<"/"<<tog.width()*tog.height()<<"\n";
	
	if (rrNbPts != 0 || area > rrArea) {
	  rrNbPts = 0;
	  rrArea = area;
	  rr = r;
	}
      }
    }
    else {
      //region touches border
      if (nb < rrNbPts) {

	//std::cerr<<"region "<<r<<" nbPtsOnBorder="<<nb<<" < rrNbPts="<<rrNbPts<<"\n";
	
	const size_t area = girl::tools::computeArea(tog, r);
	if (area > MIN_AREA) {
	  rrNbPts = nb;
	  rrArea = area;
	  rr = r;
	}
      }
    }
    
  }

  //std::cerr<<"return rr="<<rr<<" [rrArea="<<rrArea<<" rrNbPts="<<rrNbPts<<"]\n";
  
  return rr;
}

class Painter : public girl::toger::pointIterator
{
  cv::Mat &m_mask;
  
public:

  explicit Painter(cv::Mat &m) :
    m_mask(m)
  {
    assert(m.type() == CV_8UC1);
  }

  virtual void processPoint(const girl::point &pt)
  {
    m_mask.at<uchar>(pt.y(), pt.x()) = 255;
  }
  
};

class MaskSplitter : public girl::toger::sameRegion
{
  const cv::Mat &m_mask;

public:
  explicit MaskSplitter(const cv::Mat &m)
    : m_mask(m)
  {
    assert(m_mask.type() == CV_8UC1);
  }

  virtual bool same(const girl::point &p, girl::direction dir)
  {
    girl::point p2 = p;
    p2.move(dir);

    return m_mask.at<uchar>(p.y(), p.x()) == m_mask.at<uchar>(p2.y(), p2.x());
  }
		
};


/*
  We want to shrink the region a little,
to avoid to take some greenish pixels on the border.

*/
girl::region
findWoundRegion2(girl::toger &tog, const girl::regionDeque createdRegions)
{
  girl::region r = findWoundRegion(tog, createdRegions);

  cv::Mat mask = cv::Mat::zeros(tog.height(), tog.width(), CV_8UC1);
  Painter p(mask);
  tog.iterateOnRegionDomain(r, p);

  const int erosion_size = 2;
  const int erosion_type = cv::MORPH_ELLIPSE;
  cv::Mat element = cv::getStructuringElement( erosion_type,
					       cv::Size( 2*erosion_size + 1, 2*erosion_size+1 ),
					       cv::Point( erosion_size, erosion_size ) );
  cv::Mat mask2;
  cv::erode(mask, mask2, element);

  /*
  cv::Mat diff = (mask-mask2);
  cv::imshow("mask", mask);
  cv::imshow("diff", diff);
  cv::imshow("mask2", mask2);
  cv::waitKey(0);
  */
  
  girl::toger tog2(tog.width(), tog.height());
  MaskSplitter msp(mask2);
  girl::regionDeque createdRegions2;
  tog2.splitRegion(1, msp, createdRegions2);

  /*
  std::cerr<<"total area="<<tog.width()*tog.height()<<"\n";
  std::cerr<<"createdRegions2.size()="<<createdRegions2.size()<<"\n";
  for ( girl::regionDeque::const_iterator it = createdRegions2.begin();
	it != createdRegions2.end();
	++it) {
    std::cerr<<"region "<<*it<<" area="<<girl::tools::computeArea(tog2, *it)<<"\n";
  }
  */
  
  for (int i=0; i<mask2.rows; ++i) {
    const uchar *m = mask2.ptr<uchar>(i);
    for (int j=0; j<mask2.cols; ++j) {
      if (m[j] == 255) {

	tog.swap(tog2);

	r = tog.findRegion(girl::point(j, i));

	/*
	std::cerr<<"found r="<<r<<"\n";
	std::cerr<<"  area="<<girl::tools::computeArea(tog, r)<<"\n";
	*/
	
	return r;
      }
    }
  }

  return 0;
}


//CODE DUPLICATION with urgoeye.cpp
static
float
roundFloat(float f, int n=1)
{
  const float v = pow(10, n);
  //return floorf(f*v + 0.5f)/v;
  const float r = floorf(f*v + 0.5f)/v;
  //std::cerr<<"f="<<f<<" f*v="<<f*v<<" f*v+0.5f="<<f*v+0.5f<<" floorf(f*v + 0.5f)="<<floorf(f*v + 0.5f)<<"\n";
  return r;
}

int
main(int argc, char *argv[])
{
  if (argc != 3) {
    std::cerr<<"Usage: "<<argv[0]<<" image outputMask\n";
    exit(10);
  }

  const char *imageFilename = argv[1];
  const char *outputMaskFilename = argv[2];

  cv::Mat img = cv::imread(imageFilename);
  if (img.empty()) {
    std::cerr<<"Error: unable to load image file: "<<imageFilename<<"\n";
    exit(10);
  }
  assert(img.type() == CV_8UC3);

  /*
  unsigned int count=0;
  for (int i=0; i<img.rows; ++i) {
    for (int j=0; j<img.cols; ++j) {
      if (isGreen(img.at<cv::Vec3b>(i, j))) {
	++count;
	//img.at<cv::Vec3b>(i, j) = cv::Vec3b(255, 0, 255);
      }
      //else img.at<cv::Vec3b>(i, j) = cv::Vec3b(255, 255, 255);

	
    }
  }

  std::cerr<<count<<" green pixels on "<<img.rows*img.cols<<" pixels\n";
  */
  
  girl::toger tog(img.cols, img.rows);

  girl::regionDeque createdRegions;
  Splitter s(img);
  tog.splitRegion(1, s, createdRegions);

  //std::cerr<<createdRegions.size()<<" regions on "<<img.cols<<"x"<<img.rows<<" image\n";

  girl::region wr = findWoundRegion2(tog, createdRegions);
  if (wr != 0) {
    cv::Mat mask = cv::Mat::zeros(tog.height(), tog.width(), CV_8UC1);
    Painter p(mask);
    tog.iterateOnRegionDomain(wr, p);
    cv::imwrite(std::string(outputMaskFilename), mask);
  }


  
  return 0;
}
