
#include <girl/girlHashFunc.hpp>
#include <girl/girlHashMap.hpp>

#ifndef NDEBUG
//check that regions are unique in @a regions
template <typename T>
bool
checkUnique(const T &regions) 
{
  USet regionsU;
  for (typename T::const_iterator it = regions.begin(); it!=regions.end(); ++it) {
    if (regionsU.find(*it) != regionsU.end())
      return false;
    regionsU.insert(*it);
  }
  return true;
}

//check that regions @a regions1 are all present in @a regions2.
static
bool
checkAllPresent(const girl::regionDeque &regions1, const girl::regionDeque &regions2)
{
  for (girl::regionDeque::const_iterator it = regions1.begin(); it!=regions1.end(); ++it) {
    const girl::region r = *it;
    bool found = false;
    for (girl::regionDeque::const_iterator it2 = regions2.begin(); it2!=regions2.end(); ++it2) {
      if (*it2 == r) {
	found = true;
	break;
      }
    }
    if (found == false) {
      return false;
    }
  }
  return true;
}

//check that regions @a regions1 are all present in @a regions2.
static
bool
checkAllPresent(const USet &regions1, const girl::regionDeque &regions2)
{
  for (USet::const_iterator it = regions1.begin(); it!=regions1.end(); ++it) {
    const girl::region r = *it;
    bool found = false;
    for (girl::regionDeque::const_iterator it2 = regions2.begin(); it2!=regions2.end(); ++it2) {
      if (*it2 == r) {
	found = true;
	break;
      }
    }
    if (found == false) {
      std::cerr<<"region "<<r<<" not present in regions2\n";
      return false;
    }
  }
  return true;
}


static
bool
checkAllPresent(const std::vector<cv::Point> &pts,
		const girl::toger &tog,
		const girl::regionDeque &regions2)
{
  for (PointVec::const_iterator itW = pts.begin();
       itW != pts.end(); 
       ++itW) {
    const girl::region r = tog.findRegion(girl::point(itW->x, itW->y));
    bool found = false;
    for (girl::regionDeque::const_iterator it2 = regions2.begin(); it2!=regions2.end(); ++it2) {
      if (*it2 == r) {
	found = true;
	break;
      }
    }
    if (found == false) {
      std::cerr<<"pt:("<<itW->x<<", "<<itW->y<<") => region="<<r<<" not present in given regions\n";
      return false;
    }
  }
  return true;
}

#endif //NDEBUG


static
void
updateMeanVarianceWithToger(const cv::Mat &res, const girl::toger &tog, const girl::regionDeque &regions, RegionMeanProbaH &probas)
{
  assert(res.type() == CV_32F);
  assert(res.cols == tog.width() && res.rows == tog.height());

  MeanComputer mc(res);

  for (girl::regionDeque::const_iterator it = regions.begin();
       it != regions.end();
       ++it) {

    const girl::region r = *it;

    assert(tog.isRegionValid(r));

    mc.clear();
    tog.iterateOnRegionDomain(r, mc);
    
    float m0, m1, m2;
    mc.getMoments(m0, m1, m2);
    assert(m0 > 0);

    probas[*it] = Moments(m0, m1, m2);
  }
}


static const float SPLITAGAIN_THRESHOLD_MEAN = 0.5f;
static const float SPLITAGAIN_THRESHOLD_VARIANCE = 0.05f;
static const int SPLITAGAIN_NB_COLORS = 6; //26; //12;

/**

@param[in, out] createdRegions
 */
static 
void
splitAgain_aux(cv::Mat &imgProba,  
	       RegionMeanProbaH &regionProbas4,   
	       ise::SplitAlgorithmDefault &splitAlgo,
	       ise::SplitDriverDefault &splitDriver,
	       girl::regionDeque &createdRegions,  //will be modified
	       ise::SegmentationContext &segContext,
	       float thresholdMean = SPLITAGAIN_THRESHOLD_MEAN,
	       float thresholdVariance = SPLITAGAIN_THRESHOLD_VARIANCE,
	       const int nbColors = SPLITAGAIN_NB_COLORS
	       )
{
  assert(checkUnique(createdRegions));
#ifndef NDEBUG
  girl::regionDeque DBG_originalRegions = createdRegions;
  USet DBG_finalRegions;
#endif


  girl::toger &tog = *(segContext.getToger());

  int times = 2;

  USet result;

  ise::QuantificationNbColors g(&segContext, ISE_RGB_to_Lab, nbColors);

  //girl::regionDeque allRegions;
  //tog.allRegions(allRegions);
  //updateMeanVarianceWithToger(imgProba, tog, allRegions, regionProbas4);
  //TODO:OPTIM !!!!! apply updateMeanVarianceWithToger only on createdRegions !!!!????

  updateMeanVarianceWithToger(imgProba, tog, createdRegions, regionProbas4);
  


  do{
    
    girl::regionDeque createdRegionNew;
 
    for (girl::regionDeque::const_iterator it = createdRegions.begin();
	 it != createdRegions.end();
	 ++it) 
      {
	const girl::region r = *it;
	RegionMeanProbaH::const_iterator itH = regionProbas4.find(r);
	assert(itH != regionProbas4.end());

	const float meanP = itH->second.getMean();
	const float variance = itH->second.getVariance();
	  
	if ((variance > thresholdVariance) && (meanP > thresholdMean))
	    {
	      girl::regionDeque regs2;
	      girl::regionDeque createdRegions2;
	      regs2.push_back(r);

	      //	      g.setParameters(ISE_RGB_to_Lab, nbClasses, regionArea, flashLuminanceThreshold);
	      ise::SegmentationClustering &segClust = g;
	      splitAlgo.apply(regs2, splitDriver, segClust, 0, createdRegions2);

	      //std::cerr << "Nombre de régions Resultantes d'un split" << createdRegions2.size() << "\n" ;


	      for (girl::regionDeque::const_iterator it2 = createdRegions2.begin();
		   it2 != createdRegions2.end();
		   ++it2) 
		{
		  createdRegionNew.push_back(*it2);
		  //result.insert(*it2);
#ifndef NDEBUG
		  DBG_finalRegions.insert(*it2);
#endif
		}
	    }
	else
	  {
	    result.insert(r);
#ifndef NDEBUG
	    DBG_finalRegions.insert(r);
#endif
	  }
      }

    updateMeanVarianceWithToger(imgProba, tog, createdRegionNew, regionProbas4);

    std::swap(createdRegions, createdRegionNew);

    if (createdRegions.size() == 0)
      break;

    --times;
    
  } while(times > 0);
  

  if (! createdRegions.empty()) {
    for (girl::regionDeque::const_iterator it = createdRegions.begin();
	 it != createdRegions.end();
	 ++it) 
      result.insert(*it);
  }

  createdRegions.clear();
  for(USet::const_iterator it = result.begin(); it!=result.end(); ++it) {
    createdRegions.push_back(*it);
  }
  
  assert(checkUnique(createdRegions));
  assert(checkAllPresent(DBG_originalRegions, createdRegions));
  assert(checkAllPresent(DBG_finalRegions, createdRegions));
}


/**

@param[in, out] createdRegions
 */
static 
void
splitAgain(cv::Mat &imgProba,  
	   RegionMeanProbaH &regionProbas4,   
	   ise::SplitAlgorithmDefault &splitAlgo,
	   ise::SplitDriverDefault &splitDriver,
	   girl::regionDeque &createdRegions,  //will be modified
	   ise::SegmentationContext &segContext)
{
  splitAgain_aux(imgProba, regionProbas4, splitAlgo, splitDriver, createdRegions, segContext, SPLITAGAIN_THRESHOLD_MEAN, SPLITAGAIN_THRESHOLD_VARIANCE, SPLITAGAIN_NB_COLORS);
}


/*
  Resplit regions in @a createdRegions for which one of the points in @a skinPts is inside.
  Regions are splitted again if they contain both a point from @a skinPts & @ woundPts.

  Regions are splitted with splitAgain.
  In produced regions, the ones with the points are inserted in @a otherRegions,
  and other are inserted in @a createdRegions

  @param[in, out] createdRegions
  @param[in, out] otherRegions
*/
void
splitAgainIfPtsInWrongRegions(cv::Mat &imgProba,  
			      RegionMeanProbaH &regionProbas4,   
			      ise::SplitAlgorithmDefault &splitAlgo,
			      ise::SplitDriverDefault &splitDriver,
			      girl::regionDeque &createdRegions,  //will be modified
			      girl::regionDeque &otherRegions,  //will be modified
			      ise::SegmentationContext &segContext,
			      const std::vector< std::vector<cv::Point> > &skinPts,
			      const std::vector< std::vector<cv::Point> > &woundPts)
{
  assert(checkUnique(createdRegions));
  assert(checkUnique(otherRegions));
  assert(checkNoIntersection(createdRegions, otherRegions));


  girl::toger &tog = *(segContext.getToger());

  USet regionsToSplitU;
  std::vector<cv::Point> ptsOfRegionsToSplit;
  std::vector<cv::Point> ptsWoundInRegionsToSplit;


  typedef girl::hashMap<girl::region, std::vector<cv::Point> > HashRegion2Points;
  HashRegion2Points h;
  for (PointVecVec::const_iterator itWW = woundPts.begin();
       itWW != woundPts.end(); 
       ++itWW) {
    const PointVec &ptsW = *itWW;
    for (PointVec::const_iterator itW = ptsW.begin();
	 itW != ptsW.end(); 
	 ++itW) {
      const girl::region r = tog.findRegion(girl::point(itW->x, itW->y));
      h[r].push_back(*itW);
    }
  }


  for (PointVecVec::const_iterator itVV = skinPts.begin();
       itVV != skinPts.end(); 
       ++itVV) {
    const PointVec &pts = *itVV;

    for (PointVec::const_iterator itV = pts.begin();
	 itV != pts.end(); 
	 ++itV) {

      const girl::region r = tog.findRegion(girl::point(itV->x, itV->y));
      
      for (girl::regionDeque::const_iterator it = createdRegions.begin(); it!=createdRegions.end(); ++it) {
	if (*it == r)  {
	  ptsOfRegionsToSplit.push_back(*itV);

	  if (regionsToSplitU.find(r) == regionsToSplitU.end()) {

	    regionsToSplitU.insert(r);

	    HashRegion2Points::const_iterator itH = h.find(r);
	    if (itH != h.end()) {
	      const std::vector<cv::Point> &ptsW = itH->second;
	      for (PointVec::const_iterator itW = ptsW.begin();
		   itW != ptsW.end(); 
		   ++itW) {
		ptsWoundInRegionsToSplit.push_back(*itW);
	      }
	    }
	  }
	}
      }
    }
  }
  
  assert(ptsOfRegionsToSplit.size() <= getNumPoints(skinPts));
  assert(ptsWoundInRegionsToSplit.size() <= getNumPoints(woundPts));

  //std::sort(ptsOfRegionsToSplit.begin(), ptsOfRegionsToSplit.end(), PtSorter());
  //ptsOfRegionsToSplit.erase(std::unique(ptsOfRegionsToSplit.begin(), ptsOfRegionsToSplit.end()), ptsOfRegionsToSplit.end());
  //std::cerr<<"after unique: ptsOfRegionsToSplit.size()="<<ptsOfRegionsToSplit.size()<<"/"<<nbPts<<"\n";
  //std::cerr<<"regionsToSplitU.size()="<<regionsToSplitU.size()<<"\n";
 
  if (regionsToSplitU.empty())
    return;

  USet createdRegionsU;
  for (girl::regionDeque::const_iterator it = createdRegions.begin(); it!=createdRegions.end(); ++it) {
    createdRegionsU.insert(*it);
  }

  //std::cerr<<"regionsToSplitU.size()="<<regionsToSplitU.size()<<"\n";
  //std::cerr<<"createdRegionsU.size()="<<createdRegionsU.size()<<"\n";

  girl::regionDeque regionsToSplit;
  for(USet::const_iterator it = regionsToSplitU.begin(); it!=regionsToSplitU.end(); ++it) {
    regionsToSplit.push_back(*it);
    
    createdRegionsU.erase(*it);
  }
 
  assert(createdRegionsU.size() + regionsToSplit.size() == createdRegions.size());
  assert(checkUnique(regionsToSplit));
  assert(checkNoIntersection(regionsToSplit, createdRegionsU));


  const size_t NTIMES = 20;
  size_t time = 0;

  float thresholdMeanFactor = 0.9; //0.25;
  float thresholdVarianceFactor = 0.9; //0.25;
  int nbColorsFactor = 2;

  do { 

    assert(checkAllPresent(ptsOfRegionsToSplit, tog, regionsToSplit));


    splitAgain_aux(imgProba, regionProbas4, splitAlgo, splitDriver, regionsToSplit, segContext, 
		   SPLITAGAIN_THRESHOLD_MEAN*thresholdMeanFactor, 
		   SPLITAGAIN_THRESHOLD_VARIANCE*thresholdVarianceFactor, 
		   SPLITAGAIN_NB_COLORS*nbColorsFactor); //update regionsToSplit
    
    assert(checkUnique(regionsToSplit));
    
    assert(checkAllPresent(ptsOfRegionsToSplit, tog, regionsToSplit));


    h.clear();
    for (PointVec::const_iterator itW = ptsWoundInRegionsToSplit.begin();
	 itW != ptsWoundInRegionsToSplit.end(); 
	 ++itW) {
      const girl::region r = tog.findRegion(girl::point(itW->x, itW->y));
      h[r].push_back(*itW);
    }
    
    USet regionsToKeep; //region that stay in woundRegions/createdRegions
    USet regionsToRemove; //region to add to skinRegions/otherRegions
    USet regionsToReSplit; //region to re-split
    for (PointVec::const_iterator itV = ptsOfRegionsToSplit.begin();
	 itV != ptsOfRegionsToSplit.end(); 
	 ++itV) {
      const girl::region r = tog.findRegion(girl::point(itV->x, itV->y));
      
      HashRegion2Points::const_iterator itH = h.find(r);
      if (itH == h.end()) { //region has not any wound pts in it, then can be considered as skinRegion.
	regionsToRemove.insert(r);
      }
      else {
	regionsToReSplit.insert(r); //region has both a skinPt & a woundPt.
      }
    }
    
    
    /*
    std::cerr<<"regionsToSplit.size()="<<regionsToSplit.size()<<"\n";
    std::cerr<<"regionsToKeep.size()="<<regionsToKeep.size()<<"\n";
    std::cerr<<"regionsToRemove.size()="<<regionsToRemove.size()<<"\n";
    std::cerr<<"regionsToReSplit.size()="<<regionsToReSplit.size()<<"\n";
    */

    assert(regionsToRemove.size() <= regionsToSplit.size());
    assert(checkAllPresent(regionsToRemove, regionsToSplit));
    
    for (girl::regionDeque::const_iterator it = regionsToSplit.begin(); it!=regionsToSplit.end(); ++it) {
      const girl::region r = *it;
      if (regionsToReSplit.find(r) == regionsToReSplit.end()) {
	if (regionsToRemove.find(r) == regionsToRemove.end()) {
	  createdRegionsU.insert(r);
	  regionsToKeep.insert(r);
	}
      else {
	otherRegions.push_back(r);
      }
      }
    }
    
    assert(regionsToKeep.size()+regionsToRemove.size()+regionsToReSplit.size() == regionsToSplit.size());
  
    if (regionsToReSplit.empty()) {
      break;
    }

    regionsToSplit.clear();
    for(USet::const_iterator it = regionsToReSplit.begin(); it!=regionsToReSplit.end(); ++it) {
      regionsToSplit.push_back(*it);
    }
    
    PointVec ptsOfRegionsToSplitNew;
    for (PointVec::const_iterator itV = ptsOfRegionsToSplit.begin();
       itV != ptsOfRegionsToSplit.end(); 
	 ++itV) {
      const girl::region r = tog.findRegion(girl::point(itV->x, itV->y));
      if (regionsToReSplit.find(r) != regionsToReSplit.end())
	ptsOfRegionsToSplitNew.push_back(*itV);
    }
    assert(! ptsOfRegionsToSplitNew.empty());
    std::swap(ptsOfRegionsToSplitNew, ptsOfRegionsToSplit);
    
    
    thresholdMeanFactor *= 0.5;
    thresholdVarianceFactor *= 0.5;
    nbColorsFactor *=2;
 
  
    ++time;
  }
  while (time < NTIMES);


  createdRegions.clear();
  for(USet::const_iterator it = createdRegionsU.begin(); it!=createdRegionsU.end(); ++it) {
    createdRegions.push_back(*it);
  }
  

}
