
namespace {   

  class PointGather : public girl::toger::pointIterator
  {

    std::vector<cv::Point> m_pts;

  public:
  
    PointGather()
      : m_pts()
    {}

    virtual void processPoint(const girl::point &pt)
    {
      m_pts.push_back(cv::Point(pt.x(), pt.y()));
    }
  
    const std::vector<cv::Point> &getPts() const
    {
      return m_pts;
    }

  };

  class ConvexHull
  {
    std::vector<cv::Point> m_hullPts;
  public:

    typedef std::vector<cv::Point> PointVector;

    ConvexHull()
      : m_hullPts()
    {}

    ConvexHull(const girl::toger &tog, const girl::region r)
      : m_hullPts()
    {
      compute(tog, r);
    }

    void compute(const girl::toger &tog, const girl::region r)
    {
      PointGather pg;
      tog.iterateOnRegionDomain(r, pg); //TODO:OPTIM: only taverse external contour and not domain !!!
    
      //m_area = pg.getPts().size();

      cv::convexHull(pg.getPts(), m_hullPts);

      //std::cerr<<"for "<<pg.getPts().size()<<" hull: "<<m_hullPts.size()<<" pts\n";
    }

    const std::vector<cv::Point> &getHullPts() const 
    { 
      return m_hullPts; 
    }


    float ratioAreaInside(const girl::toger &tog, const girl::region r2)
    {
      assert(! m_hullPts.empty());

      PointGather pg;
      tog.iterateOnRegionDomain(r2, pg); //here we want to traverse Domain !
    
      const std::vector<cv::Point> &pts = pg.getPts();
      const size_t area = pts.size();
    
      size_t areaInside = 0;
      for (std::vector<cv::Point>::const_iterator it = pts.begin();
	   it != pts.end();
	   ++it) {
	cv::Point2f pt = *it;
	double b = cv::pointPolygonTest(m_hullPts, pt, false);
	areaInside += (b > 0 ? 1 : 0);
      }

      assert(areaInside <= area);
      assert(area != 0);

      //std::cerr<<" r2="<<r2<<" areaInside="<<areaInside<<" area="<<area<<" ratio="<<areaInside / (float) area<<" \n";

      return areaInside / (float) area;
    }

  };


} //end anonymous namespace



#ifdef SAVE_PROBA

namespace {   
  template<class T>
  void
  drawHull(cv::Mat &img, const std::vector<T> &hull, const cv::Scalar color)
  {
    const size_t s = hull.size();
    if (s < 2)
      return;
    
    cv::Point2f pt0 = hull[s-1];
    for (size_t i=0; i<s; ++i) {
      cv::line(img, pt0, hull[i], color, 1, 8);
      pt0 = hull[i];
    }
  }
} //end anonymous namespace

static
void
drawHull(cv::Mat &img, const ConvexHull &h, const cv::Scalar color)
{
  drawHull(img, h.getHullPts(), color);
}

#endif //SAVE_PROBA
