/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ISEWEIGHTEDREGIONSETINTERFACE_HPP
#define ISEWEIGHTEDREGIONSETINTERFACE_HPP

#include "iseRegionSetInterface.hpp"

namespace ise {
  class GIRL_API WeightedRegionSetInterface : public RegionSetInterface
  {

  public:
    
    WeightedRegionSetInterface(ise::RegionSetInterfacePtr regSet, std::vector<double> weights);

    virtual void getRegionFeatures(const girl::region &id, RegionFeature &rf);

    virtual void compute(const girl::region &/*id*/, ise::RegionFeature &/*feature*/) {}
    
    virtual void mergeFeatures(RegionFeature &/*keptFeatures*/,
			       RegionFeature &/*delFeatures*/,
			       const girl::region &/*keptId*/,
			       const girl::region &/*delId*/) {}

    virtual size_t getFeatureDim() const;

    virtual void getDimDescription(std::vector<std::string> &dimDesc) const;

    virtual void getRequiredComputers(FeatureComputerListType &computers) const;

    virtual void reset();

    virtual const std::string uri() const;

    RegionSetInterfacePtr getRegSet() const { return m_regSet; }

  private:

    ise::RegionSetInterfacePtr m_regSet;
    std::vector<double> m_weights;

  };

  typedef girl::shared_ptr<WeightedRegionSetInterface> WeightedRegionSetInterfacePtr;
}

#endif /* ! ISEWEIGHTEDREGIONSETINTERFACE_HPP */
