/*
  Set of functions to split/merge:clean a toger.
  Copyright (C) 2012 Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISETOGERUTILS_HPP
#define ISETOGERUTILS_HPP

#include <girl/girlCommon.hpp>
#include <girl/girlToger.hpp>

namespace ise {

  /**
   * @brief Merge recursively small regions in @a regs of toger @a tog.
   * A region is considered small if its area is smaller than @a threshold.
   *
   * @param[in, out] regs   regions from which small regions will be merged.
   * @param[in, out] tog    toger will be modified by merging small regions.
   * @param[in] threshold   area threshold. regions with area small than this thresholed will be merged.
   *
   * @warning @a regs is modified by this function.
   */
  extern GIRL_API void mergeSmallRegions(girl::regionDeque &regs, girl::toger &tog, double threshold);

  /**
   * @brief Merge recursively small regions of toger @a tog.
   * A region is considered small if its area is smaller than @a threshold.
   *
   * @param[in, out] tog    toger will be modified by merging small regions.
   * @param[in] threshold   area threshold. regions with area small than this thresholed will be merged.
   *
   */
  extern GIRL_API void mergeSmallRegions(girl::toger &tog, double threshold);
  

}//end ise namespace
  
#endif /* ! ISETOGERUTILS_HPP */
