/*
  Set of functions to split/merge:clean a toger.
  Copyright (C) 2012 Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseTogerUtils.hpp"

#include <cassert>
#include <girlTools/girlToolsRegionInfos.hpp>
#include <ise/iseSegmentationContext.hpp>
#include <ise/iseMergeAlgorithmDefault.hpp>
#include <ise/iseMergeDriverAlways.hpp>

namespace ise {

  static
  bool
  getSmallRegs(const girl::toger &tog,
	       double threshold,
	       const girl::regionDeque &toCheck,
	       girl::regionDeque &smallRegs)
  {
    smallRegs.clear();
    
    girl::regionDeque::const_iterator it = toCheck.begin();
    const girl::regionDeque::const_iterator itEnd = toCheck.end();
    for (; it != itEnd; ++it) {
      if (girl::tools::computeArea(tog, *it) < threshold) //TODO:OPTIM: area computed from scratch each time !
	smallRegs.push_back(*it);
    }
    return smallRegs.size() > 0;
  }
  
  void
  mergeSmallRegions(girl::regionDeque &regs, girl::toger &tog, double threshold)
  {
    ise::SegmentationContext segContext(&tog, NULL);
    ise::MergeDriverAlways mergeDriver(&segContext);
    ise::MergeAlgorithmDefault mergeAlgo(&segContext);
    
    assert(regs.size() <= tog.numRegions());
    girl::regionDeque smallRegs;
    while (getSmallRegs(tog, threshold, regs, smallRegs)) {
      assert(smallRegs.size() <= tog.numRegions());
      regs.clear();
      mergeAlgo.apply(smallRegs, mergeDriver, 1, regs);
      assert(regs.size() <= tog.numRegions());
    }
    assert(regs.size() <= tog.numRegions());
  }

  void
  mergeSmallRegions(girl::toger &tog, double threshold)
  {
    girl::regionDeque regs;
    tog.allRegions(regs);
    
    mergeSmallRegions(regs, tog, threshold);
  }  

}
