/*
  Functions to compute various measures on moments.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISESTAT_HPP
#define ISESTAT_HPP

#include <girlTools/girlToolsVector.hpp>

GIRL_API double iseStat_iseComputeMean(double m0,
				       double m1);

GIRL_API double iseStat_iseComputeSQE(double m0, 
				      const girl::tools::Flt3 &m1, 
				      const girl::tools::Flt3 &m2);

GIRL_API double iseStat_iseComputeSQE(int channel,
				      double m0, 
				      const girl::tools::Flt3 &m1, 
				      const girl::tools::Flt3 &m2);

GIRL_API double iseStat_iseComputeSQE(double m0,
				      const double *m1,
				      const double *m2,
				      size_t size);

GIRL_API double iseStat_iseComputeVariance(double m0, 
					   double m1,
					   double m2);

GIRL_API double iseStat_iseComputeVariance(double m0, 
					   const girl::tools::Flt3 &m1, 
					   const girl::tools::Flt3 &m2);

GIRL_API double iseStat_iseComputeVariance(double m0, 
					   const double *m1, 
					   const double *m2,
					   size_t size);

GIRL_API double iseStat_iseComputeVariance(int channel,
					   double m0, 
					   const girl::tools::Flt3 &m1, 
					   const girl::tools::Flt3 &m2);

#endif /* ISESTAT_HPP */
