/*
  Split driver base class.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef SPLITDRIVER_HPP
#define SPLITDRIVER_HPP

#include <girl/girlToger.hpp>

namespace ise {

  class SegmentationContext;


  class GIRL_API SplitDriver 
  {
  public:

    virtual ~SplitDriver() {}

    SplitDriver(ise::SegmentationContext *segContext)
      : m_segContext(segContext)
    {}

    virtual ise::SegmentationContext *getSegContext() const 
    { 
      return m_segContext; 
    }

    virtual void setSegContext(ise::SegmentationContext *s) 
    { 
      m_segContext = s; 
    }

    virtual void init(const girl::regionDeque &regionsToSplit, int level) = 0;

    virtual void init(girl::region r, int level) = 0;

    virtual bool toSplit(girl::region r, int level) const = 0;

  private:
    SplitDriver(const SplitDriver &);
    SplitDriver &operator=(const SplitDriver &);

  protected:

    ise::SegmentationContext *m_segContext;

  };

}


#endif /* ! SPLITDRIVER_HPP */
