/*
  Default split algorithm.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISESPLITALGORITHMDEFAULT_HPP
#define ISESPLITALGORITHMDEFAULT_HPP

#include <girl/girlCommon.hpp>
#include "iseSplitAlgorithm.hpp"


namespace ise {

  class GIRL_API SplitAlgorithmDefault : public SplitAlgorithm
  {
  public :

    virtual ~SplitAlgorithmDefault() {}

    explicit SplitAlgorithmDefault(ise::SegmentationContext *segContext);

    virtual void apply(const girl::regionDeque &regions2split, 
		       ise::SplitDriver &driver,
		       ise::SegmentationClustering &clust,
		       int level,
		       girl::regionDeque &createdRegions);
    
    

    
   

  protected:

    //public or protected ???
    // must be protected now Jean Phi.


    void splitOneRegion(girl::region r, 
			ise::SplitDriver &driver, 
			ise::SegmentationClustering &clust,
			int level,
			girl::regionDeque &createdRegions);
    
  };


}

#endif /*ISESPLITALGORITHMDEFAULT_HPP*/
