/*
  Default split algorithm.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseSplitAlgorithmDefault.hpp"

#include "iseSplitDriver.hpp"
#include "iseSegmentationClustering.hpp"
#include "iseSegmentationContext.hpp"

using namespace ise;


SplitAlgorithmDefault::SplitAlgorithmDefault(ise::SegmentationContext *segContext)
  :
  SplitAlgorithm(segContext)
{

}

void 
SplitAlgorithmDefault::apply(const girl::regionDeque &regions2split, 
			     ise::SplitDriver &driver,
			     ise::SegmentationClustering &clust,
			     int level,
			     girl::regionDeque &createdRegions)
{

  //initHandleSplitOneRegion(driver, clust, regions2split, level);
  driver.init(regions2split, level);
  clust.init(regions2split, level);

  girl::regionDeque::const_iterator it = regions2split.begin();
  const girl::regionDeque::const_iterator itEnd = regions2split.end();
  for ( ; it != itEnd; ++it) 
    splitOneRegion(*it, driver, clust, level, createdRegions);
}


void
SplitAlgorithmDefault::splitOneRegion(girl::region r, 
				      ise::SplitDriver &/*driver */, 
				      ise::SegmentationClustering &clust,
				      int /*level*/,
				      girl::regionDeque &createdRegions)
{
  m_segContext->getToger()->splitRegion(r, clust, createdRegions); 
}
