/*
  Split algorithm base class.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISESPLITALGORITHM_HPP
#define ISESPLITALGORITHM_HPP

#include <girl/girlToger.hpp>

namespace ise {

  class SegmentationContext;
  class SplitDriver;
  class SegmentationClustering;


  class GIRL_API SplitAlgorithm 
  {
  public :

    virtual ~SplitAlgorithm() 
    {}

    SplitAlgorithm(ise::SegmentationContext *segContext)
      : m_segContext(segContext)
    {}

      
    virtual ise::SegmentationContext *getSegContext() const 
    { 
      return m_segContext; 
    }

    virtual void setSegContext(ise::SegmentationContext *s) 
    { 
      m_segContext = s; 
    }


    virtual void apply(const girl::regionDeque &regions2split, 
		       ise::SplitDriver &driver,
		       ise::SegmentationClustering &clust,
		       int level,
		       girl::regionDeque &createdRegions) = 0;

  protected:

    ise::SegmentationContext *m_segContext;

  private:

    SplitAlgorithm(const SplitAlgorithm &);
    SplitAlgorithm &operator=(const SplitAlgorithm &);
  };


}

#endif /*ISESPLITALGORITHM_HPP*/
