/*
  Segmentation context: toger, image, region features, ...
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "iseSegmentationContext.hpp"

#include "iseRegionTools.hpp"



using namespace ise;

SegmentationContext::SegmentationContext(girl::toger *tog,
					 girl::tools::Image *img, void *)
:
    //  m_imageLabel(NULL),
    m_regSets(),
    //   m_imageFeatures(),
    m_tog(tog),
    m_img(img),
    m_featuresMap()
{
  if (img != NULL)
    fillLabelImage();
  fillRegSet();
}

SegmentationContext::~SegmentationContext()
{
  /* //No ! Done automatically by girl::toger::Observer from which SegmentationContext inherits.
  if (m_tog) {
    m_tog->removeObserver(this);
  }
  */
}


void
SegmentationContext::addRegionSet(girl::shared_ptr<RegionSetInterface> rs)
{
  // no need, this should be done automatically when creating the feature computers
  //  if (m_tog) {
  //    girl::regionDeque regs;
  //    m_tog->allRegions(regs);
  //
  //    girl::regionDeque::const_iterator it = regs.begin();
  //    const girl::regionDeque::const_iterator itEnd = regs.end();
  //    for ( ;it != itEnd; ++it)
  //      rs->insertRegion(*it);
  //  }
  m_regSets.add(rs);

#ifndef NDEBUG
  // checkAllRegions();
#endif
}

const girl::shared_ptr<RegionSetInterface>
SegmentationContext::getRegionSet(const std::string &uri) const
{
  girl::shared_ptr<FeatureComputer> c = m_regSets.getFeatureComputer(uri);
  assert(c);
  girl::shared_ptr<RegionSetInterface> rc = girl::static_pointer_cast<RegionSetInterface>(c);
  return rc;
}


void
SegmentationContext::newRegion(const girl::regionDeque &regions)
{

  // No loops, Handler takes care of this
  m_regSets.newRegion(regions);
  //
  //  girl::regionDeque::const_iterator regIt;
  //  const girl::regionDeque::const_iterator regItEnd = regions.end();
  //  for ( regIt = regions.begin(); regIt != regItEnd; ++regIt)
  //    m_regSets.insertRegion(*regIt);

#ifndef NDEBUG
  // checkAllRegions();
#endif
}


void
SegmentationContext::updateRegion(const girl::regionDeque &regions)
{
  //  girl::regionDeque::const_iterator regIt;
  //  const girl::regionDeque::const_iterator regItEnd = regions.end();
  //  for ( regIt = regions.begin(); regIt != regItEnd; ++regIt)
  // m_regSets.replaceRegion(*regIt); //region may already exist thus must use replaceRegion

  m_regSets.updateRegion(regions);

#ifndef NDEBUG
  //  checkAllRegions();
#endif
}

void
SegmentationContext::deleteRegion(girl::region regionId)
{
  m_regSets.deleteRegion(regionId);
}

void
SegmentationContext::mergeRegions(girl::region keptRegionId, girl::region delRegionId)
{
  m_regSets.mergeRegions(keptRegionId, delRegionId);
}

void
SegmentationContext::renameRegion(girl::region oldRegionId, girl::region newRegionId)
{
  m_regSets.renameRegion(oldRegionId, newRegionId);
}

void
SegmentationContext::addImageFeatureComputer(girl::shared_ptr<ise::ImageFeatureComputer> imgF)
{
  //  m_imageFeatures.add(imgF);
  m_regSets.add(imgF);
}

void
SegmentationContext::removeImageFeature(const std::string &uri, bool removeDep)
{
  assert(m_regSets.exists(uri));
  FeatureComputer::FeatureComputerListType dep;
  m_regSets.remove(uri, removeDep, dep);
}

const girl::shared_ptr<girl::tools::ImageFeature>
SegmentationContext::getImageFeature(const std::string &title)
{
  return getImageFeatureComputer(title)->getImageFeature();
}

const girl::shared_ptr<ImageFeatureComputer>
SegmentationContext::getImageFeatureComputer(const std::string &title)
{
  assert(m_regSets.exists(title));
  girl::shared_ptr<ImageFeatureComputer> computer =
      girl::static_pointer_cast<ImageFeatureComputer>(m_regSets.getFeatureComputer(title));
  return computer;
}

void
SegmentationContext::getImageFeaturesUri(std::vector<std::string> &list,
    const std::string &imageFeatureComputerUri) const
{
  FeatureComputer::FeatureComputerListType computers;
  m_regSets.getComputerList<ImageFeatureComputer>(computers);


  // TODO: optim? return a featureComputerList?
  std::vector<std::string> titles;
  FeatureComputer::FeatureComputerListType::const_iterator cIt = computers.begin();
  const FeatureComputer::FeatureComputerListType::const_iterator cItEnd = computers.end();
  for (; cIt != cItEnd; ++cIt) {
      titles.push_back(*cIt);
  }
  if (imageFeatureComputerUri.empty()) {
      list = titles;
      return;
  }

  std::vector<std::string>::const_iterator it = titles.begin();
  const std::vector<std::string>::const_iterator itEnd = titles.end();
  for (; it != itEnd; ++it) {
//      girl::shared_ptr<ImageFeatureComputer> computer =
//          m_regSets.getFeatureComputer<ImageFeatureComputer>(*it);
      const std::string uri = *it;// computer->imageFeatureComputerUri();
      std::vector<std::string> computerUris;
      size_t  firstPos = 0;
      size_t pos = uri.find_first_of(ise::ImageFeatureComputer::IMAGE_FEATURE_URI_SEPARATOR, firstPos);
      while ( pos <= uri.length() ) {
          computerUris.push_back(uri.substr(firstPos, pos - firstPos));
          firstPos = pos+1;
          pos = uri.find_first_of(ise::ImageFeatureComputer::IMAGE_FEATURE_URI_SEPARATOR, firstPos);
      }
      computerUris.push_back(uri.substr(firstPos, uri.length()));
      for (size_t i = 0 ; i < computerUris.size() ; ++i) {
          if (imageFeatureComputerUri == computerUris[i]) {
              list.push_back(*it);
          }
      }
  }
}

void
SegmentationContext::getImageFeaturesBaseUri(std::vector<std::string> &list,
    const std::string &imageFeatureComputerUri) const
{
//  std::vector<std::string> titles;
//  m_regSets.getComputerList<ImageFeatureComputer>(titles);
//
  FeatureComputer::FeatureComputerListType computers;
  m_regSets.getComputerList<ImageFeatureComputer>(computers);

  std::vector<std::string> titles;
  FeatureComputer::FeatureComputerListType::const_iterator cIt = computers.begin();
  const FeatureComputer::FeatureComputerListType::const_iterator cItEnd = computers.end();
  for (; cIt != cItEnd; ++cIt) {
      titles.push_back(*cIt);
  }


  if (imageFeatureComputerUri.empty()) {
      list = titles;
      return;
  }

  std::vector<std::string>::const_iterator it = titles.begin();
  const std::vector<std::string>::const_iterator itEnd = titles.end();
  for (; it != itEnd; ++it) {
      girl::shared_ptr<ImageFeatureComputer> computer =
          girl::static_pointer_cast<ImageFeatureComputer>(m_regSets.getFeatureComputer(*it));
      const std::string uri = computer->baseUri();
      if (uri == imageFeatureComputerUri)
        list.push_back(*it);
  }
}

void
SegmentationContext::getImageFeaturesComputerUri(std::set<std::string> &set) const
{
//  std::vector<std::string> titles;
//  m_regSets.getComputerList<ImageFeatureComputer>(titles);
  FeatureComputer::FeatureComputerListType computers;
  m_regSets.getComputerList<ImageFeatureComputer>(computers);

  std::vector<std::string> titles;
  FeatureComputer::FeatureComputerListType::const_iterator cIt = computers.begin();
  const FeatureComputer::FeatureComputerListType::const_iterator cItEnd = computers.end();
  for (; cIt != cItEnd; ++cIt) {
      titles.push_back(*cIt);
  }

  std::vector<std::string>::const_iterator it = titles.begin();
  const std::vector<std::string>::const_iterator itEnd = titles.end();
  for (; it != itEnd; ++it) {
      girl::shared_ptr<ImageFeatureComputer> computer =
          girl::static_pointer_cast<ImageFeatureComputer>(m_regSets.getFeatureComputer(*it));
      const std::string uri = computer->imageFeatureComputerUri();
      size_t  firstPos = 0;
      size_t pos = uri.find_first_of(ise::ImageFeatureComputer::IMAGE_FEATURE_URI_SEPARATOR, firstPos);
      while ( pos <= uri.length() ) {
          set.insert(uri.substr(firstPos, pos - firstPos));
          firstPos = pos+1;
          pos = uri.find_first_of(ise::ImageFeatureComputer::IMAGE_FEATURE_URI_SEPARATOR, firstPos);
      }
      set.insert(uri.substr(firstPos, uri.length()));
  }
}

bool
SegmentationContext::imageFeatureComputerExists(const std::string &title) const
{
 // return (m_regSets.getFeatureComputer<ImageFeatureComputer>(title) != girl::shared_ptr<ImageFeatureComputer>());
  return m_regSets.exists(title);
}


void
SegmentationContext::fillRegSet()
{
  m_regSets.reset();
  if (m_tog) {

      girl::regionDeque regs;
      m_tog->allRegions(regs);

      //call newRegion() hook on existing regions to populate regSets
      newRegion(regs);

      //add itself as observer
      m_tog->removeObserver(this);
      m_tog->addObserver(this);
  }
}

