/*
  Copyright (C) 2005-2009 Roigt Julian, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ISESEGMENTATIONCLUSTERINGIMAGEFEATURECLUSTERER_HPP
#define ISESEGMENTATIONCLUSTERINGIMAGEFEATURECLUSTERER_HPP

#include <girl/girlCommon.hpp>
#include <girl/girlSharedPtr.hpp>

#include "iseClusterer.hpp"
#include "iseSegmentationClustering.hpp"
#include "iseSegmentationContext.hpp"

namespace ise {

  class GIRL_API SegmentationClusteringImageFeatureClusterer : public SegmentationClustering
  {
  public:
    
    virtual ~SegmentationClusteringImageFeatureClusterer() {}

    explicit SegmentationClusteringImageFeatureClusterer(SegmentationContext *segContext);

    virtual void init(const girl::regionDeque &regions, int level);

    virtual void init(girl::region r, int level);

    void setParameters(ise::ImageFeatureComputerPtr algo, girl::shared_ptr<ise::Clusterer> clusterer);

    void getParameters(ise::ImageFeatureComputerPtr algo, girl::shared_ptr<ise::Clusterer> clusterer) const;

  protected:

    virtual bool same(const girl::point &p1, girl::direction dir);

  private:

    SegmentationClusteringImageFeatureClusterer(const SegmentationClusteringImageFeatureClusterer &);
    SegmentationClusteringImageFeatureClusterer &operator=(const SegmentationClusteringImageFeatureClusterer &);

  protected:
    
    girl::shared_ptr<ise::Clusterer> m_clusterer;
    girl::shared_ptr<ImageFeatureComputer> m_algo;

    cv::Mat m_imageLabel;
    girl::point m_shift;

  };
}

#endif /* ! ISESEGMENTATIONCLUSTERINGIMAGEFEATURECLUSTERER_HPP */
