/*
  Copyright (C) 2013 Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISESEGMENTATIONCLUSTERINGGONOGO1_HPP
#define ISESEGMENTATIONCLUSTERINGGONOGO1_HPP

#include <girl/girlToger.hpp>
#include <ise/iseSegmentationClustering.hpp>
#include <ise/iseImageLabelToger.hpp>

#include <opencv2/core/core.hpp>


namespace ise {

  class SegmentationContext;
  
  class  GIRL_API SegmentationClusteringGonogo1 : public SegmentationClustering
  {
  public :

    explicit SegmentationClusteringGonogo1(SegmentationContext *segContext);
    
    virtual ~SegmentationClusteringGonogo1() {}

    virtual void setSegContext(ise::SegmentationContext *s);

    virtual void setParameters(int colorSpace, int nbClasses, int regionArea, double flashLuminanceThreshold);

    virtual void getParameters(int &colorSpace, int &nbClasses, int &regionArea, double &flashLuminanceThreshold) const;

    
    virtual void init(const girl::regionDeque &regions, int level=1);

    virtual void init(girl::region /*r*/, int /*level*/) {} 
    
    virtual bool same(const girl::point &p, girl::direction dir);

  private:
    girl::toger m_toger;

    int m_colorSpace;
    int m_nbClasses;
    int m_regionArea;
    double m_flashLuminanceThreshold;
  };

}

#endif /* ! ISESEGMENTATIONCLUSTERINGGONOGO1_HPP */
