/*
  Quantification Kmeans class.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISESEGMENTATIONCLUSTERINGGENERICKMEANS_HPP
#define ISESEGMENTATIONCLUSTERINGGENERICKMEANS_HPP


#include <girl/girlCommon.hpp>

#include "iseConversion.hpp"
#include "iseSegmentationClustering.hpp"
#include "iseGenericKMeans.hpp"
#include <cmath>

#include <girlTools/girlToolsImageFeature.hpp>

namespace ise {

  class GIRL_API SegmentationClusteringGenericKMeans : public SegmentationClustering
  {
    
  public:
    
    /**
     * @brief Destructor.
     */
    ~SegmentationClusteringGenericKMeans();
  
    /**
     * @brief Constructor.
     * 
     */
    SegmentationClusteringGenericKMeans(SegmentationContext *segContext, 
					int nbClasses = 4);

    virtual void init(const girl::regionDeque &regions, int level);
    
    virtual void init(girl::region r, int level);
    
    void setParameters(int nbClasses, std::string imageFeatureUri) 
    { 
      m_nbClasses = nbClasses;
      m_kmeans.setNumberClasses(m_nbClasses);
      m_imageFeatureUri = imageFeatureUri;
    }

    void getParameters(int &nbClasses, std::string &imageFeatureUri) const
    { 
      nbClasses = m_nbClasses;
      imageFeatureUri = m_imageFeatureUri;
    }
    
  protected :
    
    virtual bool same(const girl::point &p1, girl::direction dir);
    
  private:
    SegmentationClusteringGenericKMeans(const SegmentationClusteringGenericKMeans &);
    SegmentationClusteringGenericKMeans &operator=(const SegmentationClusteringGenericKMeans &);

  protected:
    ise::conversion::PFConversion *m_conversion;
    int m_colorSpace;
    int m_nbClasses;
    std::vector<double> m_weightedChannelsCoeffs;
    ise::GenericKMeans<double> m_kmeans;
    std::string m_imageFeatureUri;
    int m_dim;
  };

}

#endif /* ! ISESEGMENTATIONCLUSTERINGGENERICKMEANS_HPP */
