/*
  Templated Histogram to associate a type T to a collection of regions.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef REGIONS_HISTOGRAM_HPP
#define REGIONS_HISTOGRAM_HPP

#include <map>
#include <girl/girlUnorderedSet.hpp>
#include <girl/girlHashMap.hpp>
#include <girl/girlHashFunc.hpp>
#include <girl/girlToger.hpp>


namespace ise {

  template <typename T>
  class RegionsHistogram
  {
  public:
  
    typedef girl::unorderedSet<girl::region> RegionCollection;
    typedef typename std::map<T, RegionCollection> MapType;
    typedef girl::hashMap<T, RegionCollection> HashType; 
  
    /**
     * @a brief Get an ordered map of size and set of regions in histogram.
     */
    MapType getMap() const;

    /**
     * @a brief Get an unordered map of size and set of regions in histogram.
     */    
    const HashType &getUnorderedMap() const
    {
      return m_hash;
    }

    /**
     * @a brief Add region @a r for value @a t.
     */
    void add(T t, girl::region r)
    {
      m_hash[t].insert(r);
    }
  
    /**
     * @brief clear representation.
     *
     * Remove all elements.
     */
    void clear()
    {
      m_hash.clear();
    }

    /**
     * @brief Gives number of keys in representation.
     */
    size_t size() const 
    {
      return m_hash.size();
    }

  protected:

    HashType m_hash;
  
  };


  //---------------------------------------------------

  template <typename T>
  typename RegionsHistogram<T>::MapType
  RegionsHistogram<T>::getMap() const
  {
    MapType m;
    const typename RegionsHistogram<T>::HashType::const_iterator itEnd = m_hash.end();
    for (typename RegionsHistogram<T>::HashType::const_iterator it = m_hash.begin();
	 it != itEnd;
	 ++it) {
      m[it->first] = it->second;
    }
    return m;
  }

}

#endif /* REGIONS_HISTOGRAM_HPP */
