/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONUNARYPREDICATETRUE_HPP_
#define ISEREGIONUNARYPREDICATETRUE_HPP_

#include "iseFactoryTemplate.hxx"
#include "iseRegionUnaryPredicate.hpp"

namespace ise
{
  /**
   * Implements a basic RegionUnaryPredicate that always return true
   */
  class GIRL_API RegionUnaryPredicateTrue : public RegionUnaryPredicate
  {

  public:
    /**
     * @brief Constructor
     */
    RegionUnaryPredicateTrue(ise::SegmentationContext *segContext):
      RegionUnaryPredicate(segContext)
    {}

    /**
     * @brief operator()
     * @return always return true
     */
    inline RegionUnaryPredicate::result_type
    operator()(const RegionUnaryPredicate::argument_type&)
    {
      return true;
    }

    /*
  public:
    class RegionUnaryPredicateTrueMemento : public RegionUnaryPredicateMemento
    {
      virtual void getParameters(const Mementable &) {}
      virtual void setParameters(Mementable &) const {}
    };

  public:

    virtual RegionUnaryPredicateMemento*
    createMemento() const
    {
      return new RegionUnaryPredicateTrueMemento;
    }
    */
  };

  typedef FactoryTemplate<RegionUnaryPredicate, RegionUnaryPredicateTrue> RegionUnaryPredicateTrueFactory;

}

#endif /* ISEREGIONUNARYPREDICATETRUE_HPP_ */
