/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux boris.mansencal@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONUNARYPREDICATETHRESHOLD_HPP_
#define ISEREGIONUNARYPREDICATETHRESHOLD_HPP_

#include "iseFactoryTemplate.hxx"
#include "iseRegionUnaryPredicate.hpp"
#include "iseRegionUnaryFunction.hpp"
#include "iseComparisonFunction.hpp"

namespace ise
{
  /**
   * Implements a RegionUnaryPredicate that compare the result of a RegionUnaryFunction to a threshold.
   */
  class GIRL_API RegionUnaryPredicateThreshold : public RegionUnaryPredicate
  {
    
  public:
    
    typedef girl::shared_ptr<RegionUnaryFunction> UnaryFctPtr;
    
    /**
     * @brief Constructor
     */
    explicit RegionUnaryPredicateThreshold(ise::SegmentationContext *segContext)
      : RegionUnaryPredicate(segContext),
      m_unaryFct(),
      m_comp(ise::getComparisonFunction(ise::LESS)),
      m_threshold(0.3)
	{}
    
    void setRegionUnaryFunction(UnaryFctPtr f)
    {
      m_unaryFct = f;
    }
    
    UnaryFctPtr getRegionUnaryFunction() const
    {
      return m_unaryFct;
    }
    
    void setComparisonOperator(ComparisonOperator c)
    {
      m_comp = ise::getComparisonFunction(c);
    }
    
    ComparisonOperator getComparisonOperator() const
    {
      return ise::getComparisonOperator(m_comp);
    }
    
    
    void setThreshold(double threshold)
    {
      m_threshold = threshold;
    }
    
    double getThreshold() const
    {
      return m_threshold;
    }

    RegionUnaryPredicate::result_type
      operator()(const RegionUnaryPredicate::argument_type &r)
    {
      return m_comp((*m_unaryFct)(r), m_threshold);
    }
    
  protected:
    
    
  protected:
    UnaryFctPtr m_unaryFct;
    ise::ComparisonFunction m_comp;
    double m_threshold;
  };
  
  typedef FactoryTemplate<RegionUnaryPredicate, RegionUnaryPredicateThreshold> RegionUnaryPredicateThresholdFactory;
  
}

#endif /* ISEREGIONUNARYPREDICATETHRESHOLD_HPP_ */
