/*
  Copyright (C) 2012 Jean-Philippe Domenger, Boris Mansencal boris.mansencal@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONUNARYPREDICATEBOOLCOMBINE_HPP
#define ISEREGIONUNARYPREDICATEBOOLCOMBINE_HPP

#include "iseRegionUnaryPredicate.hpp"

namespace ise
{
  /**
   * Implements a RegionUnaryPredicate that combine two RegionUnaryPredicates with a boolean operator.
   */
  class GIRL_API RegionUnaryPredicateBoolCombine : public RegionUnaryPredicate
  {
    
  public:

    typedef girl::shared_ptr<RegionUnaryPredicate> RUPPtr;
    typedef enum {AND=0, OR} BoolOperator; 
  
    /**
     * @brief Constructor
     */
    explicit RegionUnaryPredicateBoolCombine(ise::SegmentationContext *segContext)
      : RegionUnaryPredicate(segContext),
      m_p1(),
      m_p2(),
      m_op(getBoolFunction(AND))
	{}
    
    void setFirstPredicate(RUPPtr p1) { m_p1 = p1; }
    RUPPtr getFirstPredicate() const { return m_p1; }
    void setSecondPredicate(RUPPtr p2) { m_p2 = p2; }
    RUPPtr getSecondPredicate() const { return m_p2; }

    void setBoolOperator(BoolOperator b) { m_op = getBoolFunction(b); }
    BoolOperator getBoolOperator() const { return getBoolOperatorFromFunction(m_op); }

    virtual RegionUnaryPredicate::result_type
      operator()(const RegionUnaryPredicate::argument_type &r)
    {
      return m_op((*m_p1)(r), (*m_p2)(r));
    }

  protected:

    typedef bool (*BoolFunction) (bool v1, bool v2);

    static BoolFunction getBoolFunction(BoolOperator o);
    
    static BoolOperator getBoolOperatorFromFunction(BoolFunction f);

  protected:
    RUPPtr m_p1;
    RUPPtr m_p2;
    BoolFunction m_op;
  };

}

#endif /*! ISEREGIONUNARYPREDICATEBOOLCOMBINE_HPP */
