/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*
 * iseRegionUnaryPredicate.hpp
 *
 *  Created on: Oct 13, 2010
 *      Author: vieux
 */

#ifndef ISEREGIONUNARYPREDICATE_HPP_
#define ISEREGIONUNARYPREDICATE_HPP_

#include <functional>

#include <girl/girlCommon.hpp>
#include <girl/girlToger.hpp>

#include "iseAbstractFactoryTemplate.hxx"
//#include "iseParametersMemento.hpp"

namespace ise
{
  /**
    * Interface for all the functions whose definition domain is a single region
    * and that return a boolean, e.g. filter functions.
    * Operator() must be subclassed to do the actual computation of the
    * function
    * By subclassing std::unary_function, two typedefs are created:
    * RegionUnaryFunction::argument_type which is a girl::region
    * RegionUnaryPredicate::result_type which is a boolean
    */

  class GIRL_API RegionUnaryPredicate :
  public std::unary_function<girl::region, bool>
  {
  public:

    RegionUnaryPredicate(ise::SegmentationContext *segContext)
      : m_segContext(segContext) 
      {}
    
    virtual ~RegionUnaryPredicate() {}

    virtual result_type operator()(const argument_type& regId) = 0;


  protected:

    ise::SegmentationContext *m_segContext;

  };

  typedef AbstractFactoryTemplate<RegionUnaryPredicate> RegionUnaryPredicateFactory;

}


#endif /* ISEREGIONUNARYPREDICATE_HPP_ */
