/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ISEREGIONUNARYFUNCTIONWITHREGSETIDENTITY_HPP_
#define ISEREGIONUNARYFUNCTIONWITHREGSETIDENTITY_HPP_

#include <girl/girlCommon.hpp>

#include "iseFactoryTemplate.hxx"
#include "iseRegionUnaryFunctionWithRegSet.hpp"

namespace ise {

  /**
   * Identity function: returns the value of the feature vector at the
   * index specified
   */

  class GIRL_API RegionUnaryFunctionWithRegSetIdentity : public RegionUnaryFunctionWithRegSet
  {

  public:

    /**
     * Constructor
     * @param regSet, the RegionSet this object is bound to
     * @param index, the index of the channel of the region set to return
     */
    explicit RegionUnaryFunctionWithRegSetIdentity(ise::SegmentationContext *segContext)
      : RegionUnaryFunctionWithRegSet(segContext),
      m_index(0)
	{}
    
    ~RegionUnaryFunctionWithRegSetIdentity() {}
    
    /**
     * Return the i^th component of the feature vector
     */
    RegionUnaryFunction::result_type
      operator()(const RegionUnaryFunction::argument_type &regId);
    /**
     * @return index of the returned value
     */
    void getParameters(RegionUnaryFunctionWithRegSet::RegSetPtr regSet, size_t& index) const
    {
      RegionUnaryFunctionWithRegSet::getParameters(regSet);
      index = m_index;
    }

    /**
     * @param index: index of the returned value
     */
    void setParameters(RegionUnaryFunctionWithRegSet::RegSetPtr regSet, const size_t& index)
    {
      RegionUnaryFunctionWithRegSet::setParameters(regSet);
      m_index = index;
    }


    protected:

      size_t m_index;
  };

  typedef FactoryTemplate<RegionUnaryFunction, RegionUnaryFunctionWithRegSetIdentity> RegionUnaryFunctionWithRegSetIdentityFactory;

}
#endif /* ISEREGIONUNARYFUNCTIONWITHREGSETIDENTITY_HPP_ */
