#include "iseRegionUnaryFunctionWithRegSetIdentity.hpp"


namespace ise
{
  RegionUnaryFunction::result_type
  RegionUnaryFunctionWithRegSetIdentity:: operator()(const RegionUnaryFunction::argument_type &regId)
    
  {
    assert(m_memory.size() == m_regSet->getFeatureDim());
    assert(m_index < m_regSet->getFeatureDim());
    RegionFeature rf(&m_memory[0]);
    m_regSet->getRegionFeatures(regId, rf);
    return rf[m_index];
  }
  
}
