/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEREGIONUNARYFUNCTIONWITHREGSETEUCLIDEANDISTANCE_HPP_
#define ISEREGIONUNARYFUNCTIONWITHREGSETEUCLIDEANDISTANCE_HPP_

#include <girl/girlCommon.hpp>

#include "iseFactoryTemplate.hxx"
#include "iseRegionUnaryFunctionWithRegSet.hpp"



/**
 * Return the L2 norm of the region feature
 *
 */

namespace ise {
  class GIRL_API RegionUnaryFunctionWithRegSetEuclideanDistance : public RegionUnaryFunctionWithRegSet
  {
  public:

    /**
     * Constructor
     */
    explicit RegionUnaryFunctionWithRegSetEuclideanDistance(ise::SegmentationContext *segContext) :
      RegionUnaryFunctionWithRegSet(segContext)
    {}

    virtual
    ~RegionUnaryFunctionWithRegSetEuclideanDistance() {}



    RegionUnaryFunction::result_type
      operator()(const RegionUnaryFunction::argument_type &regId);

    /**
     * Get parameters associated with the regset
     */
    void
    getParameters(RegSetPtr &regSet) const
    {
      RegionUnaryFunctionWithRegSet::getParameters(regSet);
    }


    /**
     * Set parameters associated with the regset
     */
    void
    setParameters(const RegSetPtr &regSet)
    {
      RegionUnaryFunctionWithRegSet::setParameters(regSet);
    }


  };

  typedef FactoryTemplate<RegionUnaryFunction, RegionUnaryFunctionWithRegSetEuclideanDistance> RegionUnaryFunctionWithRegSetEuclideanDistanceFactory;

}
#endif /* ISEREGIONSETUNARYFUNCTIONEUCLIDEANDISTANCE_HPP_ */
