/*
  Copyright (C) 2005-2011 Jean-Philippe Domenger, Boris Mansencal,
  Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "iseRegionUnaryFunctionWithRegSetEuclideanDistance.hpp"

#include <opencv2/flann/flann.hpp>


namespace ise
{
    
  RegionUnaryFunction::result_type
  RegionUnaryFunctionWithRegSetEuclideanDistance::operator()(const RegionUnaryFunction::argument_type &regId)
  {
    assert(m_memory.size() == m_regSet->getFeatureDim());
    RegionFeature rf(&(m_memory[0]));
    m_regSet->getRegionFeatures(regId, rf);
    cvflann::ZeroIterator<RegionFeature_Data_Type> zeroDouble;
    const RegionUnaryFunction::result_type result =
#if CV_MAJOR_VERSION*100+CV_MINOR_VERSION*10+CV_SUBMINOR_VERSION < 231
      cvflann::euclidean_dist(m_memory.begin(), m_memory.end(), zeroDouble);
#else
      cvflann::L2<ise::RegionFeature_Data_Type>()(m_memory.begin(), zeroDouble, m_memory.size());
#endif
    return result;
  }
}
