/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef REGIONSETUNARYFUNCTIONWITHREGSET_HPP_
#define REGIONSETUNARYFUNCTIONWITHREGSET_HPP_

#include <girl/girlSharedPtr.hpp>

#include "iseRegionUnaryFunction.hpp"
#include "iseRegionSetInterface.hpp"

/**
 * Interface for all the functions whose definition domain is a single region
 * and that return a real, e.g. eval functions, and are bounded to a region set.
 * Operator() must be subclassed to do the actual computation of the function
 */

namespace ise
{

  class GIRL_API RegionUnaryFunctionWithRegSet : public RegionUnaryFunction
  {

  public:
    explicit RegionUnaryFunctionWithRegSet(ise::SegmentationContext *segContext)
    : RegionUnaryFunction(segContext),
      m_memory(),
      m_regSet()
    {}


    typedef girl::shared_ptr<RegionSetInterface> RegSetPtr;

    inline void
    setParameters(const RegSetPtr &regSet)
    {
      m_regSet = regSet;
      if (regSet)
	m_memory = std::vector<RegionFeature_Data_Type>(regSet->getFeatureDim());
    }

    inline void
    getParameters(RegSetPtr &regSet) const
    {
      regSet = m_regSet;
    }

  protected:

    // used for querying the regSet;
    std::vector<RegionFeature_Data_Type> m_memory;

    RegSetPtr m_regSet;

  };

}

#endif /* REGIONSETUNARYFUNCTIONWITHREGSET_HPP_ */
