/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * iseRegionUnaryFunctionTangentVariance.hpp
 *
 *  Created on: Oct 12, 2010
 *      Author: vieux
 */

#ifndef ISEREGIONUNARYFUNCTIONTANGENTVARIANCE_HPP_
#define ISEREGIONUNARYFUNCTIONTANGENTVARIANCE_HPP_


#include "iseFactoryTemplate.hxx"
#include "iseRegionTools.hpp"
#include "iseRegionUnaryFunction.hpp"
#include "iseSegmentationContext.hpp"

namespace ise
{

  /**
   * Implementation of a RegionUnaryFunction
   * Returns the tangent variance on the region outer boundary
   */
  class GIRL_API RegionUnaryFunctionTangentVariance : public RegionUnaryFunction
  {

  public:
    /**
     * Constructor
     * @param tog the toger representation
     */
    RegionUnaryFunctionTangentVariance(ise::SegmentationContext *segContext)
    : RegionUnaryFunction(segContext)
    {}

    /**
     * @return the value of the tangent variance on the region outer boundary
     */
    inline RegionUnaryFunction::result_type
    operator()(const RegionUnaryFunction::argument_type &regId)
    {
      assert(m_segContext);
      return ise::RegionTools_computeTangentVarianceOnOuterBoundary(*m_segContext->getToger(), regId);
    }


  };


  typedef FactoryTemplate<RegionUnaryFunction, RegionUnaryFunctionTangentVariance> RegionUnaryFunctionTangentVarianceFactory;

}


#endif /* ISEREGIONUNARYFUNCTIONTANGENTVARIANCE_HPP_ */
