/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONUNARYFUNCTION_HPP_
#define ISEREGIONUNARYFUNCTION_HPP_

#include <functional>

#include <girl/girlCommon.hpp>
#include <girl/girlToger.hpp>

#include "iseAbstractFactoryTemplate.hxx"
#include "iseRegionFeature.hpp"

namespace ise
{
  /**
   * Interface for all the functions whose definition domain is a single region
   * and that return a real, e.g. eval functions.
   * Operator() must be subclassed to do the actual computation of the
   * function
   * By subclassing std::unary_function, two typedefs are created:
   * RegionUnaryFunction::result_type which is of type RegionFeature_Data_type(currently double)
   * RegionUnaryFunction::argument_type which is a girl::region
   */

  class GIRL_API RegionUnaryFunction :
    public std::unary_function<girl::region, RegionFeature_Data_Type>
  {

  public:

    RegionUnaryFunction(ise::SegmentationContext *segContext)
      : m_segContext(segContext) 
      {}

    virtual ~RegionUnaryFunction() {}

    virtual result_type
      operator()(const argument_type &regId) = 0;

  protected:

    ise::SegmentationContext *m_segContext;

  };

  typedef AbstractFactoryTemplate<RegionUnaryFunction> RegionUnaryFunctionFactory;

}

#endif /* ISEREGIONUNARYFUNCTION_HPP_ */
