/*
  Set of functions to compute features on regions.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONTOOLS_HPP
#define ISEREGIONTOOLS_HPP

#include <girl/girlCommon.hpp>
#include <girl/girlToger.hpp>
#include <girlTools/girlToolsImage.hpp>

#include "iseColorimetricMomentsComputer.hpp"
#include "iseRegionColorimetricFeatures.hpp"

namespace ise {

  /**
   * @brief Compute colorimetric moments of imageFeature @a img for region @a regId in toger @a tog.
   * Moments are set in @a m0, @a m1, @a m2.
   * @a m1 and @a m2 must be pointer to 3 double.
   */
  extern GIRL_API void RegionTools_computeColorimetricMoments(const girl::toger &tog,
							      const girl::tools::ImageFeature &img,
							      girl::region regId,
							      double &m0,
							      double *m1,
							      double *m2);

  extern GIRL_API ise::RegionColorimetricFeatures *RegionTools_createRegionFeatures(const girl::toger &tog,
										    const girl::tools::ImageFeature *img,
										    girl::region regId);

  extern GIRL_API size_t RegionTools_computeLengthOfCommonBoundary(const girl::toger &tog, 
								   girl::region reg1Id,
								   girl::region reg2Id);

  extern GIRL_API double RegionTools_computeTangentVarianceOnOuterBoundary(const girl::toger &tog, 
									   girl::region regId);

  extern GIRL_API double RegionTools_computeTangentVarianceOnCommonBoundary(const girl::toger &tog, 
									    girl::region reg1Id,
									    girl::region reg2Id);

  extern GIRL_API double RegionTools_computeTangentMeanOnOuterBoundary(const girl::toger &tog, 
								       girl::region regId);

}//end ise namespace


#endif /*ISEREGIONTOOLS_HPP*/
