/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONSTRICTWEAKORDERINGWITHUNARYFUNCTIONS_HPP
#define ISEREGIONSTRICTWEAKORDERINGWITHUNARYFUNCTIONS_HPP

#include "iseRegionStrictWeakOrdering.hpp"
#include "iseRegionUnaryFunction.hpp"
#include "iseFactoryTemplate.hxx"


namespace ise
{
  class GIRL_API RegionStrictWeakOrderingWithUnaryFunctions :
    public RegionStrictWeakOrdering
  {
  public:
    RegionStrictWeakOrderingWithUnaryFunctions(ise::SegmentationContext *segContext)
      : RegionStrictWeakOrdering(segContext)
      {}

    
    typedef girl::shared_ptr<RegionUnaryFunction> UnaryFctPtr;
    typedef std::vector<UnaryFctPtr> UnaryFctCollection;

    void setParameters(const UnaryFctCollection &fcts)
    {
      m_fcts = fcts;
    }

    void getParameters(UnaryFctCollection &fcts)
    {
      fcts = m_fcts;
    }

  protected:
    UnaryFctCollection m_fcts;
    
  };
  
  
}
    


#endif /* ! ISEREGIONSTRICTWEAKORDERINGWITHUNARYFUNCTIONS_HPP */
