/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONSTRICTWEAKORDERINGDESCENDING_HPP
#define ISEREGIONSTRICTWEAKORDERINGDESCENDING_HPP

#include "iseRegionSetStrictWeakOrdering.hpp"
#include "iseFactoryTemplate.hxx"


namespace ise
{
  class GIRL_API RegionStrictWeakOrderingDescending :
    public RegionSetStrictWeakOrdering
  {
  public:

    RegionStrictWeakOrderingDescending(ise::SegmentationContext *segContext)
      : RegionSetStrictWeakOrdering(segContext)
      {}

    virtual result_type operator()(const first_argument_type &reg1Id,
                                   const second_argument_type &reg2Id) 
    {
      
      assert(m_regSet);
      assert(m_memory1);
      assert(m_memory2);
      RegionFeature rf1(m_memory1);
      RegionFeature rf2(m_memory2);
      m_regSet->getRegionFeatures(reg1Id, rf1);
      m_regSet->getRegionFeatures(reg2Id, rf2);

      const ise::RegionFeature_Data_Type *d1 = rf1.getData();
      const ise::RegionFeature_Data_Type *d2 = rf2.getData();
      const size_t featureDim = m_regSet->getFeatureDim();
      for (size_t i=0; i<featureDim; ++i) {
	if (*d1 > *d2)
	  return true;
	else if (*d1 < *d2)
	  return false;
	++d1;
	++d2;
      }
    }
    
  };
  
  typedef FactoryTemplate<RegionStrictWeakOrdering, RegionStrictWeakOrderingDescending> RegionStrictWeakOrderingDescendingFactory;
  
}
    


#endif /* ! ISEREGIONSTRICTWEAKORDERINGDESCENDING_HPP */
