/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONSTRICTWEAKORDERINGDESCENDING_HPP
#define ISEREGIONSTRICTWEAKORDERINGDESCENDING_HPP

#include "iseRegionStrictWeakOrderingWithUnaryFunctions.hpp"
#include "iseFactoryTemplate.hxx"


namespace ise
{
  class GIRL_API RegionStrictWeakOrderingDescending :
    public RegionStrictWeakOrderingWithUnaryFunctions
  {
  public:

    RegionStrictWeakOrderingDescending(ise::SegmentationContext *segContext)
      : RegionStrictWeakOrderingWithUnaryFunctions(segContext)
      {}

    virtual result_type operator()(const first_argument_type &reg1Id,
                                   const second_argument_type &reg2Id) 
    {
      UnaryFctCollection::iterator it = m_fcts.begin();
      const UnaryFctCollection::iterator itEnd = m_fcts.end();
      for ( ; it != itEnd ; ++it) {
	
	const RegionFeature_Data_Type v1 = (*(*it))(reg1Id);
	const RegionFeature_Data_Type v2 = (*(*it))(reg2Id);
	
	if (v1 > v2)
	  return true;
	else if (v1 < v2)
	  return false;
	
      }
      return false;
    }
    
  };
  
  typedef FactoryTemplate<RegionStrictWeakOrdering, RegionStrictWeakOrderingDescending> RegionStrictWeakOrderingDescendingFactory;
  
}
    


#endif /* ! ISEREGIONSTRICTWEAKORDERINGDESCENDING_HPP */
