/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEREGIONSTRICTWEAKORDERING_HPP
#define ISEREGIONSTRICTWEAKORDERING_HPP

#include "iseRegionBinaryPredicate.hpp"

namespace ise
{
  /**
   *
   * Binary Predicate P that guarantees the following properties
   * - Irreflexivity : P(r, r) is false
   * - Antisymmetry : P(r1, r2) implies !P(r2, r1)
   * - Transitivity : P(r1, r2) && P(r2, r3) implies P(r1, r3)
   * - Transitivity of equivalence
   * [see http://www.sgi.com/tech/stl/StrictWeakOredering.html ]
   */
  class GIRL_API RegionStrictWeakOrdering :
    public RegionBinaryPredicate
  {
  public:

    RegionStrictWeakOrdering(ise::SegmentationContext *segContext)
      : RegionBinaryPredicate(segContext) 
      {}


    virtual result_type operator()(const first_argument_type& ,
                                   const second_argument_type&) = 0;

  };

  typedef AbstractFactoryTemplate<RegionStrictWeakOrdering> RegionStrictWeakOrderingFactory;

}
    


#endif /* ! ISEREGIONSTRICTWEAKORDERING_HPP */
