/*
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
 * iseRegionSetParameters.hpp
 *
 *  Created on: Oct 6, 2010
 *      Author: vieux
 */

#ifndef ISEREGIONSETPARAMETERS_HPP_
#define ISEREGIONSETPARAMETERS_HPP_

#include <cassert>
#include <string>
#include <vector>

#include <girl/girlCommon.hpp>
#include <girl/girlSharedPtr.hpp>

/**
 * Class for storing parameters associated to region sets, i.e. uri, weights for the
 * region set and weights for each dimension of the feature vector, used in the merge
 * drivers
 */
namespace ise
{

  class RegionFeatureDistance;

  class GIRL_API RegionSetParameters
  {
  public:
    /**
     * Constructor:
     * @param size the dimension of the region set feature vector
     * @param weight the weight of the region set
     * Initializes the dimension weights to 1.
     */
    RegionSetParameters(size_t size,
			double weight = 1.0);

    virtual
    ~RegionSetParameters();

    inline const std::vector<double>&
    getDimWeights() const
    {
      return m_dimWeights;
    }

    /*
    inline const std::vector<double>&
    getDimWeights()
    {
      return m_dimWeights;
    }
    */

    inline void
    setDimWeights(const std::vector<double> &weights)
    {
      assert(weights.size() == m_dimWeights.size());
      m_dimWeights = weights;
    }

    inline const std::string&
    getUri() const
    {
      return m_uri;
    }

    inline double
    getWeight() const
    {
      return m_weight;
    }

#if 0
    /**
     * return the usage of this dimension
     */
    inline bool
    getDimUsage(size_t index) const
    {
      assert(index < m_dimUsage.size());
      return m_dimUsage[index];
    }

    inline void
    setDimUsage(size_t index, bool use)
    {
      assert(index < m_dimUsage.size());
      m_dimUsage[index] = use;
    }
#endif

    const girl::shared_ptr<ise::RegionFeatureDistance>
    getDistanceComputer() const
    {
      return m_distComputer;
    }

  protected:

    std::vector<double> m_dimWeights;

#if 0
    std::vector<double> m_dimUsage;
#endif

    std::string m_uri;

    girl::shared_ptr<ise::RegionFeatureDistance> m_distComputer;

    double m_weight;
  };

}

#endif /* ISEREGIONSETPARAMETERS_HPP_ */
