/*
  Copyright (C) 2005-2012 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEREGIONSETINTERFACEMOMENTS_HPP_
#define ISEREGIONSETINTERFACEMOMENTS_HPP_

#include <sstream>

#include <girl/girlCommon.hpp>
#include <girl/girlSharedPtr.hpp>

#include "iseRegionSetInterface.hpp"
#include "iseSegmentationContext.hpp"
#include "iseFlt3Tools.hpp"

namespace ise {


  class GIRL_API RegionSetInterfaceMoments : public RegionSetInterface
  {
    // typedef girl::shared_ptr<girl::tools::ImageFeature> ImageFeaturePtr;

    // TODO: change!
    // I have to pass FEATURECOMPTUER instead of imageFeature because all their
    // URI are EMPTY!!!!!!!!!!! How can I be sure that the image are even computed
    // using a computer? there is clearly a problem here...


    typedef girl::shared_ptr<ise::ImageFeatureComputer> ImageFeaturePtr;

    static const RegionSetInterface::CacheType DEFAULT_CACHE_STRATEGY = RegionSetInterface::NONE;

  public:

    RegionSetInterfaceMoments(ise::SegmentationContext *segContext,
			      RegionSetInterface::CacheType cacheType = DEFAULT_CACHE_STRATEGY,
			      ImageFeaturePtr img = ImageFeaturePtr())
      : RegionSetInterface(segContext),
      m_img(img),
      m_memory(NULL)
    {
      if (m_img)
        allocateMemory();

      setCacheState(cacheType);

    }

    ~RegionSetInterfaceMoments()
    {
      freeMemory();
    }

    
    inline const
      std::string uri() const
    {
      std::stringstream ss(std::ios::in|std::ios::out);
      ss << "Moment" << URI_SEPARATOR << m_img->uri();
    //  std::cout << "URI for moment" << ss.str() << std::endl;
      // ss << __FILE__ << URI_SEPARATOR << m_imageFeatureURI;
      return ss.str();
    }
    

    inline size_t
    getFeatureDim() const
    {
      assert(m_img->getFeatureDim());
      return 2*m_img->getFeatureDim() + 1;
    }

    void getDimDescription(std::vector<std::string> &dimDesc) const;

    void
    setImageFeature(ImageFeaturePtr img)
    {
      assert(img);
      m_img = img;
      allocateMemory();
    }

    void
    m0(const girl::region& id, RegionFeature& rf);

    void
    m1(const girl::region& id, RegionFeature& rf);

    void
    m2(const girl::region& id, RegionFeature& rf);

    void
    getMoments(const girl::region& id,
	       RegionFeature& m0,
	       RegionFeature& m1,
	       RegionFeature& m2);


    void
    getRequiredComputers(FeatureComputerListType &) const;

    const std::string
    help() const;


    //R: TODO:REMOVE
    virtual void compute()
    {
      RegionSetInterface::compute();
    }

  protected:

    void
    compute(const girl::region &id,
        ise::RegionFeature &feature);

    inline void
    mergeFeatures(RegionFeature &keptFeatures,
        RegionFeature &delFeatures,
        const girl::region&,
        const girl::region&)
    {
      iseDouble_addition(keptFeatures.getData(), delFeatures.getData(), getFeatureDim());
    }

    inline void
    allocateMemory()
    {
      freeMemory();
      m_memory = new RegionFeature_Data_Type[getFeatureDim()];
    }

    inline void
    freeMemory()
    {
      delete [] m_memory;
    }

  protected:

    ImageFeaturePtr m_img;
    /**
     * Use this memory to perform get (for m0, m1, m2()), optimization so that
     * we don't allocate/free memory for each call to these functions
     */
    RegionFeature_Data_Type *m_memory;

  };
}
#endif /* ISEREGIONSETINTERFACEMOMENTS_HPP_ */
