/*
  Copyright (C) 2005-2012 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "iseRegionSetInterfaceMoments.hpp"

#include <sstream>

namespace ise
{

  //  RegionSetInterfaceMoments::RegionSetInterfaceMoments(ise::SegmentationContext* segContext,
  //      std::string imageFeatureURI,
  //      RegionSetInterface::CacheType cacheType)
  //  : RegionSetInterface(segContext, cacheType),
  //    m_imageFeatureURI(imageFeatureURI)
  //  {}


    void
    RegionSetInterfaceMoments::getDimDescription(std::vector<std::string> &dimDesc) const
    {
      dimDesc.clear();
      size_t fullSize = getFeatureDim();
      dimDesc.resize(fullSize);
      size_t s = (fullSize - 1)/2;
      std::stringstream ss;
      dimDesc[0] = "Zero order moment (m0)";
      for (size_t i = 0; i < s; ++i) {
	ss.clear();
	ss.str("");
	ss <<"First Order Moment (m1) ["<<i<<"]";
	dimDesc[i + 1] = ss.str();
	ss.clear();
	ss.str("");
	ss <<"Second Order Moment (m2) ["<<i<<"]";
	dimDesc[s + 1 + i] = ss.str();
      }
    }


  void
  RegionSetInterfaceMoments::compute(const girl::region &id, RegionFeature &feature)
  {
    assert(m_segContext);
    assert(m_segContext->getToger());
    RegionFeature_Data_Type *result = feature.getData();
    memset(result, 0, getFeatureDim()*sizeof(RegionFeature_Data_Type));
    assert(m_img->getImageFeature());
    MomentsComputerIF momentComputer(m_img->getImageFeature().get(),
        result,
        &(result[1]),
	&(result[m_img->getImageFeature()->channels() + 1]));
    m_segContext->getToger()->iterateOnRegionDomain(id, momentComputer);
  }

  void
  RegionSetInterfaceMoments::m0(const girl::region& id, RegionFeature &rf)
  {
    RegionFeature tmp(m_memory);
    getRegionFeatures(id, tmp);
    rf[0] = tmp[0];
  }

  void
  RegionSetInterfaceMoments::m1(const girl::region& id, RegionFeature &rf)
  {
    RegionFeature tmp(m_memory);
    getRegionFeatures(id, tmp);
    size_t size = (getFeatureDim() -1)/2;
    memcpy(rf.getData(), &(m_memory[1]), size*sizeof(RegionFeature_Data_Type));
//    for (size_t i = 0; i < size; ++i) {
//      rf[i] = tmp[i+1];
//    }
  }

  void
  RegionSetInterfaceMoments::m2(const girl::region& id, RegionFeature &rf)
  {
    RegionFeature tmp(m_memory);
    getRegionFeatures(id, tmp);
    size_t size = (getFeatureDim() -1)/2;
    memcpy(rf.getData(), &(m_memory[size+1]), size*sizeof(RegionFeature_Data_Type));
//    for (size_t i = 0; i < size; ++i) {
//      rf[0] = tmp[i+size+1];
//    }
  }

  void
  RegionSetInterfaceMoments::getMoments(const girl::region& id,
					RegionFeature& m0,
					RegionFeature& m1,
					RegionFeature& m2)
  {
    RegionFeature tmp(m_memory);
    getRegionFeatures(id, tmp);
    size_t size = (getFeatureDim() - 1)/2;
    memcpy(m0.getData(), m_memory, 1*sizeof(RegionFeature_Data_Type));
    memcpy(m1.getData(), &(m_memory[1]), size*sizeof(RegionFeature_Data_Type));
    memcpy(m2.getData(), &(m_memory[size+1]), size*sizeof(RegionFeature_Data_Type));
  }

  void
  RegionSetInterfaceMoments::getRequiredComputers(FeatureComputerListType &req) const
  {
    assert(m_img);
    req.insert(m_img->uri());
  }


  const std::string
  RegionSetInterfaceMoments::help() const
  {
    return "Compute m0 (area), m1 (sum of values), m2 (sum of squared values) for the pixels in the region";
  }
}
