/*
  Copyright (C) 2010-2012 Rémi Vieux, Boris Mansencal  boris.mansencal@labri.fr

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef ISEREGIONSETINTERFACEMEAN_HPP_
#define ISEREGIONSETINTERFACEMEAN_HPP_

#include <girl/girlCommon.hpp>
#include <girl/girlSharedPtr.hpp>

#include "iseRegionSetInterface.hpp"
#include "iseRegionSetInterfaceMoments.hpp"

/**
 * Compute the mean of an image feature over a region. This class uses
 * the moments to compute the mean, as mean = m1/m0
 */
namespace ise
{

  class GIRL_API RegionSetInterfaceMean : public RegionSetInterface
  {

    typedef girl::shared_ptr<ise::RegionSetInterfaceMoments> MomentsPtr;

    static const RegionSetInterface::CacheType DEFAULT_CACHE_STRATEGY = RegionSetInterface::NONE;

  public:

    RegionSetInterfaceMean(ise::SegmentationContext* segContext,
			   ise::RegionSetInterface::CacheType cacheType = DEFAULT_CACHE_STRATEGY);

    RegionSetInterfaceMean(ise::SegmentationContext* segContext,
			   MomentsPtr regSetMoment,
			   ise::RegionSetInterface::CacheType cacheType = DEFAULT_CACHE_STRATEGY);
    
    virtual
    ~RegionSetInterfaceMean();

    const std::string uri() const;

    size_t
    getFeatureDim() const;


    void
    getDimDescription(std::vector<std::string>& dimDesc) const;

    void
    setParameters(MomentsPtr regSetMoment);

    void
    getRequiredComputers(FeatureComputerListType &) const;

    const std::string
    help() const;

    // R: TODO:REMOVE
    void
    compute()
    {
      RegionSetInterface::compute();
    }

  protected:

    void
    compute(const girl::region& id, ise::RegionFeature& feature);

    void
    mergeFeatures(RegionFeature& kept,
		  RegionFeature& del,
		  const girl::region& keptId,
		  const girl::region& delId);

    void
    allocateMemory();

    void
    freeMemory();

  protected:


    MomentsPtr m_regSetMoment;

    /**
     * Used for optimization (avoiding multiple allocation/deallocation at each
     * call of compute() function). Allocate memory once at the construction, use
     * this memory for all calls and release at the destruction
     */
    RegionFeature_Data_Type *m_momentMemory;

  };

}

#endif /* ISEREGIONSETINTERFACEMEAN_HPP_ */
