/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ISEREGIONSETINTERFACEGEOMETRIC_HPP
#define ISEREGIONSETINTERFACEGEOMETRIC_HPP

#include <girl/girlCommon.hpp>

#include "iseRegionSetInterface.hpp"
#include "iseSegmentationContext.hpp"


namespace ise
{
  class GIRL_API RegionSetInterfaceGeometric  : public RegionSetInterface
    
  {
    static const int FEATURE_DIMENSION = 9;
    static const RegionSetInterface::CacheType DEFAULT_CACHE_STRATEGY = RegionSetInterface::ALWAYS;

  public:

    enum { AREA = 0,
	   PERIMETER,
	   COMPACTNESS,
	   X_COORD_CENTER,
	   Y_COORD_CENTER,
	   MAJOR_AXIS_LENGTH,
	   MINOR_AXIS_LENGTH,
	   ANGLE_MAJOR_AXIS_ABSCICE, //in degrees
	   MAJOR_MINOR_AXIS_RATIO};
      


    RegionSetInterfaceGeometric(ise::SegmentationContext* segContext,
				ise::RegionSetInterface::CacheType cacheType = DEFAULT_CACHE_STRATEGY);

    virtual
    ~RegionSetInterfaceGeometric();

    const std::string uri() const;

    size_t
    getFeatureDim() const;

    void
    getDimDescription(std::vector<std::string>& dimDesc) const;

    void
    getRequiredComputers(FeatureComputer::FeatureComputerListType &) const {}

    const std::string
    help() const;

    void compute(const girl::region &id, ise::RegionFeature &feature);

  protected:

    void mergeFeatures(RegionFeature &kept, RegionFeature &del,
		       const girl::region &keptReg, const girl::region &delId);

  private:


  };
}

#endif /* ISEREGIONSETINTERFACEGEOMETRIC_HPP */
