/*
 * iseRegionSetInterfaceClustering.hpp
 *
 *  Created on: Apr 15, 2011
 *      Author: vieux
 */

#ifndef ISEREGIONSETINTERFACECLUSTERING_HPP_
#define ISEREGIONSETINTERFACECLUSTERING_HPP_

#include <girl/girlCommon.hpp>
#include <girl/girlHashFunc.hpp>
#include <girl/girlHashMap.hpp>
#include <girl/girlSharedPtr.hpp>

#include "iseClusterer.hpp"
#include "iseRegionSetInterface.hpp"

/**
 * Perform clustering of regions and assign cluster label to each region
 */
namespace ise
{

  class GIRL_API RegionSetInterfaceClustering : public RegionSetInterface
  {

  public:
    static const FeatureComputer::CacheType DEFAULT_CACHE_STRATEGY = ise::FeatureComputer::NONE;

  public:
    RegionSetInterfaceClustering(ise::SegmentationContext *segContext,
				 FeatureComputer::CacheType cache = DEFAULT_CACHE_STRATEGY);
    virtual
    ~RegionSetInterfaceClustering();


    const std::string uri() const;

    size_t
    getFeatureDim() const;

    void
    getDimDescription(std::vector<std::string> &dimDesc) const;

    void
    setParameters(const std::vector<girl::shared_ptr<RegionSetInterface> > &regSets,
		  const std::vector<bool> &mask,
		  const girl::regionDeque &regs,
		  const girl::shared_ptr<Clusterer> &clusterer);

    void
    getRequiredComputers(FeatureComputerListType&) const;


    const std::string
    help() const;

  protected:
    void
    compute(const girl::region &id, ise::RegionFeature &feature);

    void
    mergeFeatures(RegionFeature& kept,
        RegionFeature& del,
        const girl::region& keptId,
        const girl::region& delId);

    bool
    computeClustering();

  protected:

    std::vector<girl::shared_ptr<RegionSetInterface> > m_regSets;
    girl::regionDeque m_regs;
    girl::hashMap<girl::region, double> m_regsToClusterMap;
    std::vector<bool> m_mask;
    girl::shared_ptr<Clusterer> m_clusterer;



  };

}

#endif /* ISEREGIONSETINTERFACECLUSTERING_HPP_ */
