/*
  Copyright (C) 2012 Boris Mansencal boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEREGIONSETINTERFACE_AREA_HPP
#define ISEREGIONSETINTERFACE_AREA_HPP

#include <girl/girlCommon.hpp>
#include <girl/girlSharedPtr.hpp> 

#include "iseRegionSetInterface.hpp"

namespace ise {

  class GIRL_API RegionSetInterfaceArea : public RegionSetInterface
  {
  public:

    static const int FEATURE_DIMENSION = 1;
    static const RegionSetInterface::CacheType DEFAULT_CACHE_STRATEGY = RegionSetInterface::ALWAYS;

    enum {AREA=0}; 

  public:

    RegionSetInterfaceArea(ise::SegmentationContext* segContext,
			   ise::RegionSetInterface::CacheType cacheType = DEFAULT_CACHE_STRATEGY);
    
    
    virtual ~RegionSetInterfaceArea();

    const std::string uri() const;

    size_t getFeatureDim() const;

    void getDimDescription(std::vector<std::string>& dimDesc) const;

    void getRequiredComputers(FeatureComputerListType &) const {}

    const std::string help() const;

  protected:

    void compute(const girl::region& id, ise::RegionFeature& feature);
    
    void mergeFeatures(RegionFeature& kept, RegionFeature& del,
		       const girl::region& keptId, const girl::region& delId);

  private:

  };

}

#endif /* ! ISEREGIONSETINTERFACE_AREA_HPP */
