/*
  Copyright (C) 2012 Boris Mansencal boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "iseRegionSetInterfaceArea.hpp"

#include <girlTools/girlToolsRegionInfos.hpp>
#include "iseSegmentationContext.hpp"


using namespace ise;

RegionSetInterfaceArea::RegionSetInterfaceArea(ise::SegmentationContext* segContext,
					       ise::RegionSetInterface::CacheType cacheType)
  : RegionSetInterface(segContext)
{
  setCacheState(cacheType);
}
    
RegionSetInterfaceArea::~RegionSetInterfaceArea()
{
}


const std::string
RegionSetInterfaceArea::uri() const
{
  std::stringstream ss(std::ios::in|std::ios::out);
  ss << __FILE__ << std::endl;
  return ss.str();
}


size_t
RegionSetInterfaceArea::getFeatureDim() const
{
  return FEATURE_DIMENSION;
}

void
RegionSetInterfaceArea::getDimDescription(std::vector<std::string>& dimDesc) const
{
  dimDesc.resize(FEATURE_DIMENSION);
  dimDesc[AREA] = "Area";
}

const std::string
RegionSetInterfaceArea::help() const
{
  return "This computer returns the area of regions";
}

void
RegionSetInterfaceArea::compute(const girl::region& id, ise::RegionFeature& feature)
{
  assert(m_segContext);
  const girl::toger* tog = m_segContext->getToger();
  assert(tog);
  feature[0] = girl::tools::computeArea(*tog, id);
}
    
void
RegionSetInterfaceArea::mergeFeatures(RegionFeature& kept, RegionFeature& del,
				      const girl::region& /*keptId*/, const girl::region& /*delId*/)
{
  kept[0] += del[0];
}
